/*

 Task Scheduler support header for Security Software Testing Suite
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/

*/

#ifndef __TASK_SCHEDULER_HPP__
#define __TASK_SCHEDULER_HPP__

#ifdef __cplusplus
extern "C" {
#endif

#include <oaidl.h>
#include <ocidl.h>
#include <docobj.h>


#define TASK_FLAG_INTERACTIVE                   0x1
#define TASK_FLAG_DELETE_WHEN_DONE              0x2
#define TASK_FLAG_DISABLED                      0x4
#define TASK_FLAG_START_ONLY_IF_IDLE            0x10
#define TASK_FLAG_KILL_ON_IDLE_END              0x20
#define TASK_FLAG_DONT_START_IF_ON_BATTERIES    0x40
#define TASK_FLAG_KILL_IF_GOING_ON_BATTERIES    0x80
#define TASK_FLAG_RUN_ONLY_IF_DOCKED            0x100
#define TASK_FLAG_HIDDEN                        0x200
#define TASK_FLAG_RUN_IF_CONNECTED_TO_INTERNET  0x400
#define TASK_FLAG_RESTART_ON_IDLE_RESUME        0x800
#define TASK_FLAG_SYSTEM_REQUIRED               0x1000
#define TASK_FLAG_RUN_ONLY_IF_LOGGED_ON         0x2000
#define TASK_TRIGGER_FLAG_HAS_END_DATE          0x1
#define TASK_TRIGGER_FLAG_KILL_AT_DURATION_END  0x2
#define TASK_TRIGGER_FLAG_DISABLED              0x4

#define TASK_MAX_RUN_TIMES                      1440


typedef enum _TASK_TRIGGER_TYPE
{
  TASK_TIME_TRIGGER_ONCE            = 0,
  TASK_TIME_TRIGGER_DAILY           = 1,
  TASK_TIME_TRIGGER_WEEKLY          = 2,
  TASK_TIME_TRIGGER_MONTHLYDATE     = 3,
  TASK_TIME_TRIGGER_MONTHLYDOW      = 4,
  TASK_EVENT_TRIGGER_ON_IDLE        = 5,
  TASK_EVENT_TRIGGER_AT_SYSTEMSTART = 6,
  TASK_EVENT_TRIGGER_AT_LOGON       = 7
} TASK_TRIGGER_TYPE,*PTASK_TRIGGER_TYPE;

typedef struct _DAILY
{
  WORD DaysInterval;
} DAILY;

typedef struct _WEEKLY
{
  WORD WeeksInterval;
  WORD rgfDaysOfTheWeek;
} WEEKLY;

typedef struct _MONTHLYDATE
{
  DWORD rgfDays;
  WORD rgfMonths;
} MONTHLYDATE;

typedef struct _MONTHLYDOW
{
  WORD wWhichWeek;
  WORD rgfDaysOfTheWeek;
  WORD rgfMonths;
} MONTHLYDOW;

typedef union _TRIGGER_TYPE_UNION
{
  DAILY Daily;
  WEEKLY Weekly;
  MONTHLYDATE MonthlyDate;
  MONTHLYDOW MonthlyDOW;
} TRIGGER_TYPE_UNION;

typedef struct _TASK_TRIGGER
{
  WORD cbTriggerSize;            // Structure size.
  WORD Reserved1;                // Reserved. Must be zero.
  WORD wBeginYear;               // Trigger beginning date year.
  WORD wBeginMonth;              // Trigger beginning date month.
  WORD wBeginDay;                // Trigger beginning date day.
  WORD wEndYear;                 // Optional trigger ending date year.
  WORD wEndMonth;                // Optional trigger ending date month.
  WORD wEndDay;                  // Optional trigger ending date day.
  WORD wStartHour;               // Run bracket start time hour.
  WORD wStartMinute;             // Run bracket start time minute.
  DWORD MinutesDuration;         // Duration of run bracket.
  DWORD MinutesInterval;         // Run bracket repetition interval.
  DWORD rgFlags;                 // Trigger flags.
  TASK_TRIGGER_TYPE TriggerType; // Trigger type.
  TRIGGER_TYPE_UNION Type;       // Trigger data.
  WORD Reserved2;                // Reserved. Must be zero.
  WORD wRandomMinutesInterval;   // Maximum number of random minutes after start time.
} TASK_TRIGGER, * PTASK_TRIGGER;




EXTERN_C const IID IID_ITaskTrigger;
#undef INTERFACE
#define INTERFACE ITaskTrigger
DECLARE_INTERFACE_(ITaskTrigger,IUnknown)
{
  STDMETHOD(QueryInterface)(THIS_ REFIID,PVOID*) PURE;
  STDMETHOD_(ULONG,AddRef)(THIS) PURE;
  STDMETHOD_(ULONG,Release)(THIS) PURE;

  STDMETHOD(SetTrigger)(THIS_ PTASK_TRIGGER) PURE;
  STDMETHOD(GetTrigger)(THIS_ PTASK_TRIGGER) PURE;
  STDMETHOD(GetTriggerString)(THIS_ LPWSTR *) PURE;
};



EXTERN_C const IID IID_IScheduledWorkItem;
#undef INTERFACE
#define INTERFACE IScheduledWorkItem
DECLARE_INTERFACE_(IScheduledWorkItem,IUnknown)
{
  STDMETHOD(QueryInterface)(THIS_ REFIID,PVOID*) PURE;
  STDMETHOD_(ULONG,AddRef)(THIS) PURE;
  STDMETHOD_(ULONG,Release)(THIS) PURE;

  STDMETHOD(CreateTrigger)(THIS_ WORD *,ITaskTrigger **) PURE;
  STDMETHOD(DeleteTrigger)(THIS_ WORD) PURE;
  STDMETHOD(GetTriggerCount)(THIS_ WORD *) PURE;
  STDMETHOD(GetTrigger)(THIS_ WORD,ITaskTrigger **) PURE;
  STDMETHOD(GetTriggerString)(THIS_ WORD,LPWSTR *) PURE;
  STDMETHOD(GetRunTimes)(THIS_ LPSYSTEMTIME,LPSYSTEMTIME,WORD *,LPSYSTEMTIME *) PURE;
  STDMETHOD(GetNextRunTime)(THIS_ SYSTEMTIME *) PURE;
  STDMETHOD(SetIdleWait)(THIS_ WORD,WORD) PURE;
  STDMETHOD(GetIdleWait)(THIS_ WORD *,WORD *) PURE;

  STDMETHOD(Run)(THIS) PURE;
  STDMETHOD(Terminate)(THIS) PURE;
  STDMETHOD(EditWorkItem)(THIS_ HWND,DWORD) PURE;
  STDMETHOD(GetMostRecentRunTime)(THIS_ SYSTEMTIME *) PURE;
  STDMETHOD(GetStatus)(THIS_ HRESULT *) PURE;
  STDMETHOD(GetExitCode)(THIS_ DWORD *) PURE;

  STDMETHOD(SetComment)(THIS_ LPCWSTR) PURE;
  STDMETHOD(GetComment)(THIS_ LPWSTR *) PURE;
  STDMETHOD(SetCreator)(THIS_ LPCWSTR) PURE;
  STDMETHOD(GetCreator)(THIS_ LPWSTR *) PURE;
  STDMETHOD(SetWorkItemData)(THIS_ WORD,BYTE *) PURE;
  STDMETHOD(GetWorkItemData)(THIS_ WORD *,BYTE **) PURE;
  STDMETHOD(SetErrorRetryCount)(THIS_ WORD) PURE;
  STDMETHOD(GetErrorRetryCount)(THIS_ WORD *) PURE;
  STDMETHOD(SetErrorRetryInterval)(THIS_ WORD) PURE;
  STDMETHOD(GetErrorRetryInterval)(THIS_ WORD *) PURE;
  STDMETHOD(SetFlags)(THIS_ DWORD) PURE;
  STDMETHOD(GetFlags)(THIS_ DWORD *) PURE;
  STDMETHOD(SetAccountInformation)(THIS_ LPCWSTR,LPCWSTR) PURE;
  STDMETHOD(GetAccountInformation)(THIS_ LPWSTR *) PURE;
};


EXTERN_C const IID IID_ITask;
#undef INTERFACE
#define INTERFACE ITask
DECLARE_INTERFACE_(ITask,IScheduledWorkItem)
{
  STDMETHOD(QueryInterface)(THIS_ REFIID,PVOID*) PURE;
  STDMETHOD_(ULONG,AddRef)(THIS) PURE;
  STDMETHOD_(ULONG,Release)(THIS) PURE;

  STDMETHOD(CreateTrigger)(THIS_ WORD *,ITaskTrigger **) PURE;
  STDMETHOD(DeleteTrigger)(THIS_ WORD) PURE;
  STDMETHOD(GetTriggerCount)(THIS_ WORD *) PURE;
  STDMETHOD(GetTrigger)(THIS_ WORD,ITaskTrigger **) PURE;
  STDMETHOD(GetTriggerString)(THIS_ WORD,LPWSTR *) PURE;
  STDMETHOD(GetRunTimes)(THIS_ LPSYSTEMTIME,LPSYSTEMTIME,WORD *,LPSYSTEMTIME *) PURE;
  STDMETHOD(GetNextRunTime)(THIS_ SYSTEMTIME *) PURE;
  STDMETHOD(SetIdleWait)(THIS_ WORD,WORD) PURE;
  STDMETHOD(GetIdleWait)(THIS_ WORD *,WORD *) PURE;

  STDMETHOD(Run)(THIS) PURE;
  STDMETHOD(Terminate)(THIS) PURE;
  STDMETHOD(EditWorkItem)(THIS_ HWND,DWORD) PURE;
  STDMETHOD(GetMostRecentRunTime)(THIS_ SYSTEMTIME *) PURE;
  STDMETHOD(GetStatus)(THIS_ HRESULT *) PURE;
  STDMETHOD(GetExitCode)(THIS_ DWORD *) PURE;

  STDMETHOD(SetComment)(THIS_ LPCWSTR) PURE;
  STDMETHOD(GetComment)(THIS_ LPWSTR *) PURE;
  STDMETHOD(SetCreator)(THIS_ LPCWSTR) PURE;
  STDMETHOD(GetCreator)(THIS_ LPWSTR *) PURE;
  STDMETHOD(SetWorkItemData)(THIS_ WORD,BYTE *) PURE;
  STDMETHOD(GetWorkItemData)(THIS_ WORD *,BYTE **) PURE;
  STDMETHOD(SetErrorRetryCount)(THIS_ WORD) PURE;
  STDMETHOD(GetErrorRetryCount)(THIS_ WORD *) PURE;
  STDMETHOD(SetErrorRetryInterval)(THIS_ WORD) PURE;
  STDMETHOD(GetErrorRetryInterval)(THIS_ WORD *) PURE;
  STDMETHOD(SetFlags)(THIS_ DWORD) PURE;
  STDMETHOD(GetFlags)(THIS_ DWORD *) PURE;
  STDMETHOD(SetAccountInformation)(THIS_ LPCWSTR,LPCWSTR) PURE;
  STDMETHOD(GetAccountInformation)(THIS_ LPWSTR *) PURE;


  STDMETHOD(SetApplicationName)(THIS_ LPCWSTR) PURE;
  STDMETHOD(GetApplicationName)(THIS_ LPWSTR *) PURE;
  STDMETHOD(SetParameters)(THIS_ LPCWSTR) PURE;
  STDMETHOD(GetParameters)(THIS_ LPWSTR *) PURE;
  STDMETHOD(SetWorkingDirectory)(THIS_ LPCWSTR) PURE;
  STDMETHOD(GetWorkingDirectory)(THIS_ LPWSTR *) PURE;
  STDMETHOD(SetPriority)(THIS_ DWORD) PURE;
  STDMETHOD(GetPriority)(THIS_ DWORD *) PURE;
  STDMETHOD(SetTaskFlags)(THIS_ DWORD) PURE;
  STDMETHOD(GetTaskFlags)(THIS_ DWORD *) PURE;
  STDMETHOD(SetMaxRunTime)(THIS_ DWORD) PURE;
  STDMETHOD(GetMaxRunTime)(THIS_ DWORD *) PURE;
};


const IID CLSID_CTask                   = {0x148BD520, 0xA2AB, 0x11CE, {0xB1, 0x1F, 0x00, 0xAA, 0x00, 0x53, 0x05, 0x03}};
const IID IID_ITask                     = {0x148BD524, 0xA2AB, 0x11CE, {0xB1, 0x1F, 0x00, 0xAA, 0x00, 0x53, 0x05, 0x03}};




EXTERN_C const IID IID_IEnumWorkItems;
#undef INTERFACE
#define INTERFACE IEnumWorkItems
DECLARE_INTERFACE_(IEnumWorkItems,IUnknown)
{
  STDMETHOD(QueryInterface)(THIS_ REFIID,PVOID*) PURE;
  STDMETHOD_(ULONG,AddRef)(THIS) PURE;
  STDMETHOD_(ULONG,Release)(THIS) PURE;

  STDMETHOD(Next)(THIS_ ULONG,LPWSTR **,ULONG *) PURE;
  STDMETHOD(Skip)(THIS_ ULONG) PURE;
  STDMETHOD(Reset)(THIS) PURE;
  STDMETHOD(Clone)(THIS_ IEnumWorkItems **) PURE;
};



EXTERN_C const IID IID_ITaskScheduler;
#undef INTERFACE
#define INTERFACE ITaskScheduler
DECLARE_INTERFACE_(ITaskScheduler,IUnknown)
{
  STDMETHOD(QueryInterface)(THIS_ REFIID,PVOID*) PURE;
  STDMETHOD_(ULONG,AddRef)(THIS) PURE;
  STDMETHOD_(ULONG,Release)(THIS) PURE;

  STDMETHOD(SetTargetComputer)(THIS_ LPCWSTR) PURE;
  STDMETHOD(GetTargetComputer)(THIS_ LPWSTR *) PURE;
  STDMETHOD(Enum)(THIS_ IEnumWorkItems **) PURE;
  STDMETHOD(Activate)(THIS_ LPCWSTR,REFIID,IUnknown **) PURE;
  STDMETHOD(Delete)(THIS_ LPCWSTR) PURE;
  STDMETHOD(NewWorkItem)(THIS_ LPCWSTR,REFCLSID,REFIID,IUnknown **) PURE;
  STDMETHOD(AddWorkItem)(THIS_ LPCWSTR,IScheduledWorkItem *) PURE;
  STDMETHOD(IsOfType)(THIS_ LPCWSTR,REFIID) PURE;
};



const IID CLSID_TaskScheduler           = {0xD6277990, 0x4C6A, 0x11CF, {0x8D, 0x87, 0x00, 0xAA, 0x00, 0x60, 0xF5, 0xBF}};
const IID CLSID_CTaskScheduler          = {0x148BD52A, 0xA2AB, 0x11CE, {0xB1, 0x1F, 0x00, 0xAA, 0x00, 0x53, 0x05, 0x03}};
const IID IID_ITaskScheduler            = {0x148BD527, 0xA2AB, 0x11CE, {0xB1, 0x1F, 0x00, 0xAA, 0x00, 0x53, 0x05, 0x03}};


#ifdef __cplusplus
}
#endif

#endif
