/*

 ICMP support header for Security Software Testing Suite
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/

*/

#ifndef __ICMP_H__
#define __ICMP_H__

#include <windows.h>

#define ICMP_ECHO_REPLY                 0
#define ICMP_ECHO_REQUEST               8
#define ICMP_MAX_PACKET_SIZE            65536

typedef struct IP_HEADER
{
  u_char verihl;
  u_char tos;
  short len;
  short id;
  short ffo;
  u_char ttl;
  u_char protocol;
  u_short checksum;
  struct in_addr src;
  struct in_addr dst;
} IP_HEADER,*PIP_HEADER;

typedef struct ICMP_HEADER
{
  u_char type;
  u_char code;
  u_short checksum;
  u_short id;
  u_short seq;
  char data[ANYSIZE_ARRAY];
} ICMP_HEADER,*PICMP_HEADER;

typedef struct ECHO_REQUEST
{
  ICMP_HEADER icmp_hdr;
  DWORD time;
  char data[ANYSIZE_ARRAY];
} ECHO_REQUEST,*PECHO_REQUEST;

typedef struct ECHO_REPLY
{
  IP_HEADER ip_hdr;
  ECHO_REQUEST req;
} ECHO_REPLY,*PECHO_REPLY;




#endif
