/*

 DirectInput support header for Security Software Testing Suite
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/

*/

#ifndef __DINPUT_HPP__
#define __DINPUT_HPP__

#ifdef __cplusplus
extern "C" {
#endif

#define DISCL_EXCLUSIVE     0x00000001
#define DISCL_NONEXCLUSIVE  0x00000002
#define DISCL_FOREGROUND    0x00000004
#define DISCL_BACKGROUND    0x00000008
#define DISCL_NOWINKEY      0x00000010

#define DIK_ESCAPE          0x01
#define DIK_1               0x02
#define DIK_2               0x03
#define DIK_3               0x04
#define DIK_4               0x05
#define DIK_5               0x06
#define DIK_6               0x07
#define DIK_7               0x08
#define DIK_8               0x09
#define DIK_9               0x0A
#define DIK_0               0x0B
#define DIK_MINUS           0x0C
#define DIK_EQUALS          0x0D
#define DIK_BACK            0x0E
#define DIK_TAB             0x0F
#define DIK_Q               0x10
#define DIK_W               0x11
#define DIK_E               0x12
#define DIK_R               0x13
#define DIK_T               0x14
#define DIK_Y               0x15
#define DIK_U               0x16
#define DIK_I               0x17
#define DIK_O               0x18
#define DIK_P               0x19
#define DIK_LBRACKET        0x1A
#define DIK_RBRACKET        0x1B
#define DIK_RETURN          0x1C
#define DIK_LCONTROL        0x1D
#define DIK_A               0x1E
#define DIK_S               0x1F
#define DIK_D               0x20
#define DIK_F               0x21
#define DIK_G               0x22
#define DIK_H               0x23
#define DIK_J               0x24
#define DIK_K               0x25
#define DIK_L               0x26
#define DIK_SEMICOLON       0x27
#define DIK_APOSTROPHE      0x28
#define DIK_GRAVE           0x29
#define DIK_LSHIFT          0x2A
#define DIK_BACKSLASH       0x2B
#define DIK_Z               0x2C
#define DIK_X               0x2D
#define DIK_C               0x2E
#define DIK_V               0x2F
#define DIK_B               0x30
#define DIK_N               0x31
#define DIK_M               0x32
#define DIK_COMMA           0x33
#define DIK_PERIOD          0x34
#define DIK_SLASH           0x35
#define DIK_RSHIFT          0x36
#define DIK_MULTIPLY        0x37
#define DIK_LMENU           0x38
#define DIK_SPACE           0x39
#define DIK_CAPITAL         0x3A
#define DIK_F1              0x3B
#define DIK_F2              0x3C
#define DIK_F3              0x3D
#define DIK_F4              0x3E
#define DIK_F5              0x3F
#define DIK_F6              0x40
#define DIK_F7              0x41
#define DIK_F8              0x42
#define DIK_F9              0x43
#define DIK_F10             0x44
#define DIK_NUMLOCK         0x45
#define DIK_SCROLL          0x46
#define DIK_NUMPAD7         0x47
#define DIK_NUMPAD8         0x48
#define DIK_NUMPAD9         0x49
#define DIK_SUBTRACT        0x4A
#define DIK_NUMPAD4         0x4B
#define DIK_NUMPAD5         0x4C
#define DIK_NUMPAD6         0x4D
#define DIK_ADD             0x4E
#define DIK_NUMPAD1         0x4F
#define DIK_NUMPAD2         0x50
#define DIK_NUMPAD3         0x51
#define DIK_NUMPAD0         0x52
#define DIK_DECIMAL         0x53
#define DIK_OEM_102         0x56
#define DIK_F11             0x57
#define DIK_F12             0x58
#define DIK_F13             0x64
#define DIK_F14             0x65
#define DIK_F15             0x66
#define DIK_KANA            0x70
#define DIK_ABNT_C1         0x73
#define DIK_CONVERT         0x79
#define DIK_NOCONVERT       0x7B
#define DIK_YEN             0x7D
#define DIK_ABNT_C2         0x7E
#define DIK_NUMPADEQUALS    0x8D
#define DIK_PREVTRACK       0x90
#define DIK_AT              0x91
#define DIK_COLON           0x92
#define DIK_UNDERLINE       0x93
#define DIK_KANJI           0x94
#define DIK_STOP            0x95
#define DIK_AX              0x96
#define DIK_UNLABELED       0x97
#define DIK_NEXTTRACK       0x99
#define DIK_NUMPADENTER     0x9C
#define DIK_RCONTROL        0x9D
#define DIK_MUTE            0xA0
#define DIK_CALCULATOR      0xA1
#define DIK_PLAYPAUSE       0xA2
#define DIK_MEDIASTOP       0xA4
#define DIK_VOLUMEDOWN      0xAE
#define DIK_VOLUMEUP        0xB0
#define DIK_WEBHOME         0xB2
#define DIK_NUMPADCOMMA     0xB3
#define DIK_DIVIDE          0xB5
#define DIK_SYSRQ           0xB7
#define DIK_RMENU           0xB8
#define DIK_PAUSE           0xC5
#define DIK_HOME            0xC7
#define DIK_UP              0xC8
#define DIK_PRIOR           0xC9
#define DIK_LEFT            0xCB
#define DIK_RIGHT           0xCD
#define DIK_END             0xCF
#define DIK_DOWN            0xD0
#define DIK_NEXT            0xD1
#define DIK_INSERT          0xD2
#define DIK_DELETE          0xD3
#define DIK_LWIN            0xDB
#define DIK_RWIN            0xDC
#define DIK_APPS            0xDD
#define DIK_POWER           0xDE
#define DIK_SLEEP           0xDF
#define DIK_WAKE            0xE3
#define DIK_WEBSEARCH       0xE5
#define DIK_WEBFAVORITES    0xE6
#define DIK_WEBREFRESH      0xE7
#define DIK_WEBSTOP         0xE8
#define DIK_WEBFORWARD      0xE9
#define DIK_WEBBACK         0xEA
#define DIK_MYCOMPUTER      0xEB
#define DIK_MAIL            0xEC
#define DIK_MEDIASELECT     0xED


typedef struct DIDEVCAPS
{
  DWORD dwSize;
  DWORD dwFlags;
  DWORD dwDevType;
  DWORD dwAxes;
  DWORD dwButtons;
  DWORD dwPOVs;
  DWORD dwFFSamplePeriod;
  DWORD dwFFMinTimeResolution;
  DWORD dwFirmwareRevision;
  DWORD dwHardwareRevision;
  DWORD dwFFDriverVersion;
} DIDEVCAPS, *LPDIDEVCAPS;

typedef struct DIPROPHEADER
{
  DWORD dwSize;
  DWORD dwHeaderSize;
  DWORD dwObj;
  DWORD dwHow;
} DIPROPHEADER, *LPDIPROPHEADER;
typedef const DIPROPHEADER *LPCDIPROPHEADER;

typedef struct DIDEVICEOBJECTDATA
{
  DWORD dwOfs;
  DWORD dwData;
  DWORD dwTimeStamp;
  DWORD dwSequence;
} DIDEVICEOBJECTDATA, *LPDIDEVICEOBJECTDATA;
typedef const DIDEVICEOBJECTDATA *LPCDIDEVICEOBJECTDATA;

typedef struct _DIOBJECTDATAFORMAT
{
  const GUID *pguid;
  DWORD dwOfs;
  DWORD dwType;
  DWORD dwFlags;
} DIOBJECTDATAFORMAT, *LPDIOBJECTDATAFORMAT;
typedef const DIOBJECTDATAFORMAT *LPCDIOBJECTDATAFORMAT;

typedef struct _DIDATAFORMAT
{
  DWORD dwSize;
  DWORD dwObjSize;
  DWORD dwFlags;
  DWORD dwDataSize;
  DWORD dwNumObjs;
  LPDIOBJECTDATAFORMAT rgodf;
} DIDATAFORMAT, *LPDIDATAFORMAT;
typedef const DIDATAFORMAT *LPCDIDATAFORMAT;

extern const DIDATAFORMAT c_dfDIKeyboard;

typedef struct DIDEVICEOBJECTINSTANCEA
{
  DWORD dwSize;
  GUID guidType;
  DWORD dwOfs;
  DWORD dwType;
  DWORD dwFlags;
  CHAR tszName[MAX_PATH];
  DWORD dwFFMaxForce;
  DWORD dwFFForceResolution;
  WORD wCollectionNumber;
  WORD wDesignatorIndex;
  WORD wUsagePage;
  WORD wUsage;
  DWORD dwDimension;
  WORD wExponent;
  WORD wReportId;
} DIDEVICEOBJECTINSTANCEA, *LPDIDEVICEOBJECTINSTANCEA;
typedef const DIDEVICEOBJECTINSTANCEA *LPCDIDEVICEOBJECTINSTANCEA;

typedef struct DIDEVICEINSTANCEA
{
  DWORD dwSize;
  GUID guidInstance;
  GUID guidProduct;
  DWORD dwDevType;
  CHAR tszInstanceName[MAX_PATH];
  CHAR tszProductName[MAX_PATH];
  GUID guidFFDriver;
  WORD wUsagePage;
  WORD wUsage;
} DIDEVICEINSTANCEA, *LPDIDEVICEINSTANCEA;
typedef const DIDEVICEINSTANCEA *LPCDIDEVICEINSTANCEA;

typedef BOOL (FAR PASCAL * LPDIENUMDEVICEOBJECTSCALLBACKA)(LPCDIDEVICEOBJECTINSTANCEA, LPVOID);

#undef INTERFACE
#define INTERFACE IDirectInputDeviceA
DECLARE_INTERFACE_(IDirectInputDeviceA, IUnknown)
{
  STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID * ppvObj) PURE;
  STDMETHOD_(ULONG,AddRef)(THIS) PURE;
  STDMETHOD_(ULONG,Release)(THIS) PURE;
  STDMETHOD(GetCapabilities)(THIS_ LPDIDEVCAPS) PURE;
  STDMETHOD(EnumObjects)(THIS_ LPDIENUMDEVICEOBJECTSCALLBACKA,LPVOID,DWORD) PURE;
  STDMETHOD(GetProperty)(THIS_ REFGUID,LPDIPROPHEADER) PURE;
  STDMETHOD(SetProperty)(THIS_ REFGUID,LPCDIPROPHEADER) PURE;
  STDMETHOD(Acquire)(THIS) PURE;
  STDMETHOD(Unacquire)(THIS) PURE;
  STDMETHOD(GetDeviceState)(THIS_ DWORD,LPVOID) PURE;
  STDMETHOD(GetDeviceData)(THIS_ DWORD,LPDIDEVICEOBJECTDATA,LPDWORD,DWORD) PURE;
  STDMETHOD(SetDataFormat)(THIS_ LPCDIDATAFORMAT) PURE;
  STDMETHOD(SetEventNotification)(THIS_ HANDLE) PURE;
  STDMETHOD(SetCooperativeLevel)(THIS_ HWND,DWORD) PURE;
  STDMETHOD(GetObjectInfo)(THIS_ LPDIDEVICEOBJECTINSTANCEA,DWORD,DWORD) PURE;
  STDMETHOD(GetDeviceInfo)(THIS_ LPDIDEVICEINSTANCEA) PURE;
  STDMETHOD(RunControlPanel)(THIS_ HWND,DWORD) PURE;
  STDMETHOD(Initialize)(THIS_ HINSTANCE,DWORD,REFGUID) PURE;
};
typedef struct IDirectInputDeviceA *LPDIRECTINPUTDEVICEA;



typedef struct DIENVELOPE
{
  DWORD dwSize;
  DWORD dwAttackLevel;
  DWORD dwAttackTime;
  DWORD dwFadeLevel;
  DWORD dwFadeTime;
} DIENVELOPE, *LPDIENVELOPE;

typedef struct DIEFFECT
{
  DWORD dwSize;
  DWORD dwFlags;
  DWORD dwDuration;
  DWORD dwSamplePeriod;
  DWORD dwGain;
  DWORD dwTriggerButton;
  DWORD dwTriggerRepeatInterval;
  DWORD cAxes;
  LPDWORD rgdwAxes;
  LPLONG rglDirection;
  LPDIENVELOPE lpEnvelope;
  DWORD cbTypeSpecificParams;
  LPVOID lpvTypeSpecificParams;
  DWORD dwStartDelay;
} DIEFFECT, *LPDIEFFECT;
typedef const DIEFFECT *LPCDIEFFECT;

typedef struct DIFILEEFFECT
{
  DWORD dwSize;
  GUID GuidEffect;
  LPCDIEFFECT lpDiEffect;
  CHAR szFriendlyName[MAX_PATH];
} DIFILEEFFECT, *LPDIFILEEFFECT;
typedef const DIFILEEFFECT *LPCDIFILEEFFECT;

typedef BOOL (FAR PASCAL * LPDIENUMEFFECTSINFILECALLBACK)(LPCDIFILEEFFECT , LPVOID);

typedef struct DIEFFESCAPE
{
  DWORD dwSize;
  DWORD dwCommand;
  LPVOID lpvInBuffer;
  DWORD cbInBuffer;
  LPVOID lpvOutBuffer;
  DWORD cbOutBuffer;
} DIEFFESCAPE, *LPDIEFFESCAPE;

typedef struct DIEFFECTINFOA
{
  DWORD dwSize;
  GUID guid;
  DWORD dwEffType;
  DWORD dwStaticParams;
  DWORD dwDynamicParams;
  CHAR tszName[MAX_PATH];
} DIEFFECTINFOA, *LPDIEFFECTINFOA;
typedef const DIEFFECTINFOA *LPCDIEFFECTINFOA;


typedef BOOL (FAR PASCAL * LPDIENUMEFFECTSCALLBACKA)(LPCDIEFFECTINFOA, LPVOID);

#undef INTERFACE
#define INTERFACE IDirectInputEffect
DECLARE_INTERFACE_(IDirectInputEffect, IUnknown)
{
  STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID * ppvObj) PURE;
  STDMETHOD_(ULONG,AddRef)(THIS) PURE;
  STDMETHOD_(ULONG,Release)(THIS) PURE;
  STDMETHOD(Initialize)(THIS_ HINSTANCE,DWORD,REFGUID) PURE;
  STDMETHOD(GetEffectGuid)(THIS_ LPGUID) PURE;
  STDMETHOD(GetParameters)(THIS_ LPDIEFFECT,DWORD) PURE;
  STDMETHOD(SetParameters)(THIS_ LPCDIEFFECT,DWORD) PURE;
  STDMETHOD(Start)(THIS_ DWORD,DWORD) PURE;
  STDMETHOD(Stop)(THIS) PURE;
  STDMETHOD(GetEffectStatus)(THIS_ LPDWORD) PURE;
  STDMETHOD(Download)(THIS) PURE;
  STDMETHOD(Unload)(THIS) PURE;
  STDMETHOD(Escape)(THIS_ LPDIEFFESCAPE) PURE;
};
typedef struct IDirectInputEffect *LPDIRECTINPUTEFFECT;

typedef BOOL (FAR PASCAL * LPDIENUMCREATEDEFFECTOBJECTSCALLBACK)(LPDIRECTINPUTEFFECT, LPVOID);


#undef INTERFACE
#define INTERFACE IDirectInputDevice2A
DECLARE_INTERFACE_(IDirectInputDevice2A, IDirectInputDeviceA)
{
  STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID * ppvObj) PURE;
  STDMETHOD_(ULONG,AddRef)(THIS) PURE;
  STDMETHOD_(ULONG,Release)(THIS) PURE;
  STDMETHOD(GetCapabilities)(THIS_ LPDIDEVCAPS) PURE;
  STDMETHOD(EnumObjects)(THIS_ LPDIENUMDEVICEOBJECTSCALLBACKA,LPVOID,DWORD) PURE;
  STDMETHOD(GetProperty)(THIS_ REFGUID,LPDIPROPHEADER) PURE;
  STDMETHOD(SetProperty)(THIS_ REFGUID,LPCDIPROPHEADER) PURE;
  STDMETHOD(Acquire)(THIS) PURE;
  STDMETHOD(Unacquire)(THIS) PURE;
  STDMETHOD(GetDeviceState)(THIS_ DWORD,LPVOID) PURE;
  STDMETHOD(GetDeviceData)(THIS_ DWORD,LPDIDEVICEOBJECTDATA,LPDWORD,DWORD) PURE;
  STDMETHOD(SetDataFormat)(THIS_ LPCDIDATAFORMAT) PURE;
  STDMETHOD(SetEventNotification)(THIS_ HANDLE) PURE;
  STDMETHOD(SetCooperativeLevel)(THIS_ HWND,DWORD) PURE;
  STDMETHOD(GetObjectInfo)(THIS_ LPDIDEVICEOBJECTINSTANCEA,DWORD,DWORD) PURE;
  STDMETHOD(GetDeviceInfo)(THIS_ LPDIDEVICEINSTANCEA) PURE;
  STDMETHOD(RunControlPanel)(THIS_ HWND,DWORD) PURE;
  STDMETHOD(Initialize)(THIS_ HINSTANCE,DWORD,REFGUID) PURE;
  STDMETHOD(CreateEffect)(THIS_ REFGUID,LPCDIEFFECT,LPDIRECTINPUTEFFECT *,LPUNKNOWN) PURE;
  STDMETHOD(EnumEffects)(THIS_ LPDIENUMEFFECTSCALLBACKA,LPVOID,DWORD) PURE;
  STDMETHOD(GetEffectInfo)(THIS_ LPDIEFFECTINFOA,REFGUID) PURE;
  STDMETHOD(GetForceFeedbackState)(THIS_ LPDWORD) PURE;
  STDMETHOD(SendForceFeedbackCommand)(THIS_ DWORD) PURE;
  STDMETHOD(EnumCreatedEffectObjects)(THIS_ LPDIENUMCREATEDEFFECTOBJECTSCALLBACK,LPVOID,DWORD) PURE;
  STDMETHOD(Escape)(THIS_ LPDIEFFESCAPE) PURE;
  STDMETHOD(Poll)(THIS) PURE;
  STDMETHOD(SendDeviceData)(THIS_ DWORD,LPCDIDEVICEOBJECTDATA,LPDWORD,DWORD) PURE;
};
typedef struct IDirectInputDevice2A *LPDIRECTINPUTDEVICE2A;

#define IDirectInputDevice2 IDirectInputDevice2A
typedef struct IDirectInputDevice2 *LPDIRECTINPUTDEVICE2;


typedef BOOL (FAR PASCAL * LPDIENUMDEVICESCALLBACKA)(LPCDIDEVICEINSTANCEA, LPVOID);

#undef INTERFACE
#define INTERFACE IDirectInputA
DECLARE_INTERFACE_(IDirectInputA, IUnknown)
{
  STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID * ppvObj) PURE;
  STDMETHOD_(ULONG,AddRef)(THIS) PURE;
  STDMETHOD_(ULONG,Release)(THIS) PURE;
  STDMETHOD(CreateDevice)(THIS_ REFGUID,LPDIRECTINPUTDEVICEA *,LPUNKNOWN) PURE;
  STDMETHOD(EnumDevices)(THIS_ DWORD,LPDIENUMDEVICESCALLBACKA,LPVOID,DWORD) PURE;
  STDMETHOD(GetDeviceStatus)(THIS_ REFGUID) PURE;
  STDMETHOD(RunControlPanel)(THIS_ HWND,DWORD) PURE;
  STDMETHOD(Initialize)(THIS_ HINSTANCE,DWORD) PURE;
};

#undef INTERFACE
#define INTERFACE IDirectInput2A
DECLARE_INTERFACE_(IDirectInput2A, IDirectInputA)
{
  STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID * ppvObj) PURE;
  STDMETHOD_(ULONG,AddRef)(THIS) PURE;
  STDMETHOD_(ULONG,Release)(THIS) PURE;
  STDMETHOD(CreateDevice)(THIS_ REFGUID,LPDIRECTINPUTDEVICEA *,LPUNKNOWN) PURE;
  STDMETHOD(EnumDevices)(THIS_ DWORD,LPDIENUMDEVICESCALLBACKA,LPVOID,DWORD) PURE;
  STDMETHOD(GetDeviceStatus)(THIS_ REFGUID) PURE;
  STDMETHOD(RunControlPanel)(THIS_ HWND,DWORD) PURE;
  STDMETHOD(Initialize)(THIS_ HINSTANCE,DWORD) PURE;
  STDMETHOD(FindDevice)(THIS_ REFGUID,LPCSTR,LPGUID) PURE;
};

#undef INTERFACE
#define INTERFACE IDirectInput7A
DECLARE_INTERFACE_(IDirectInput7A, IDirectInput2A)
{
  STDMETHOD(QueryInterface)(THIS_ REFIID riid, LPVOID * ppvObj) PURE;
  STDMETHOD_(ULONG,AddRef)(THIS) PURE;
  STDMETHOD_(ULONG,Release)(THIS) PURE;
  STDMETHOD(CreateDevice)(THIS_ REFGUID,LPDIRECTINPUTDEVICEA *,LPUNKNOWN) PURE;
  STDMETHOD(EnumDevices)(THIS_ DWORD,LPDIENUMDEVICESCALLBACKA,LPVOID,DWORD) PURE;
  STDMETHOD(GetDeviceStatus)(THIS_ REFGUID) PURE;
  STDMETHOD(RunControlPanel)(THIS_ HWND,DWORD) PURE;
  STDMETHOD(Initialize)(THIS_ HINSTANCE,DWORD) PURE;
  STDMETHOD(FindDevice)(THIS_ REFGUID,LPCSTR,LPGUID) PURE;
  STDMETHOD(CreateDeviceEx)(THIS_ REFGUID,REFIID,LPVOID *,LPUNKNOWN) PURE;
};

typedef struct IDirectInput7A *LPDIRECTINPUT7A;

#define IDirectInput7 IDirectInput7A
typedef struct IDirectInput7 *LPDIRECTINPUT7;

DEFINE_GUID(IID_IDirectInput7A,      0x9A4CB684,0x236D,0x11D3,0x8E,0x9D,0x00,0xC0,0x4F,0x68,0x44,0xAE);
DEFINE_GUID(IID_IDirectInputDevice2A,0x5944E682,0xC92E,0x11CF,0xBF,0xC7,0x44,0x45,0x53,0x54,0x00,0x00);
DEFINE_GUID(GUID_SysKeyboard,        0x6F1D2B61,0xD5A0,0x11CF,0xBF,0xC7,0x44,0x45,0x53,0x54,0x00,0x00);
#define IID_IDirectInput7 IID_IDirectInput7A
#define IID_IDirectInputDevice2 IID_IDirectInputDevice2A
#define IDirectInputDevice2 IDirectInputDevice2A



#ifdef __cplusplus
}
#endif

#endif
