/*

 Header file for Security Software Testing Suite - Shared code library for universal testing function
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/

*/

#ifndef __LP_COMMON_UNIV_H__
#define __LP_COMMON_UNIV_H__

#include <windows.h>
#include <winsock.h>
#include "common.h"
#include "funcdef_kernel32.h"
#include "funcdef_ws2_32.h"

// flags for com_univ_init()
#define COM_UNIV_INIT_FLAG_WS2_32               1 << 0  // initialize 'ws2_32.dll' functions


/*
 Universal error codes.
*/
// function com_univ_fix_func_kernel()
#define COM_UNIV_ERR_FIX_FUNC_KERNEL_GET_BASE                           0x000000001     // Unable to find "kernel32.dll" inside the current process.
// function com_univ_load_second_dll()
#define COM_UNIV_ERR_LOAD_SECOND_DLL_INVALID_DLL_NAME                   0x000000010     // The name of the second DLL is invalid.
#define COM_UNIV_ERR_LOAD_SECOND_DLL_LOAD_LIBRARY                       0x000000011     // Unable to load the second DLL using.
// function com_univ_job_stack_push()
#define COM_UNIV_ERR_JOB_STACK_PUSH_STACK_FULL                          0x000000020     // The job's stack is full.
// function com_univ_job_stack_pop()
#define COM_UNIV_ERR_JOB_STACK_POP_STACK_EMPTY                          0x000000024     // The job's stack is empty.
// function com_univ_job_stack_get()
#define COM_UNIV_ERR_JOB_STACK_GET_INDEX_INVALID                        0x000000028     // Invalid item index.
// function com_univ_job_stack_remove()
#define COM_UNIV_ERR_JOB_STACK_REMOVE_STACK_EMPTY                       0x000000040     // Stack should contain an item but was empty.
// function com_univ_server_init()
#define COM_UNIV_ERR_SERVER_INIT_CREATE_EVENT                           0x000000080     // Unable to create mapping event.
#define COM_UNIV_ERR_SERVER_INIT_CREATE_FILE_MAPPING                    0x000000081     // Unable to create file mapping.
#define COM_UNIV_ERR_SERVER_INIT_MAP_VIEW_OF_FILE                       0x000000082     // Unable to map file mapping into the current process.
// function com_univ_wait_mapping_event_handle()
#define COM_UNIV_ERR_WAIT_MAPPING_EVENT_HANDLE_TERMINATED               0x0000000A0     // The process the function waited for has been terminated.
#define COM_UNIV_ERR_WAIT_MAPPING_EVENT_HANDLE_TIMEOUT                  0x0000000A1     // The waiting took too long.
#define COM_UNIV_ERR_WAIT_MAPPING_EVENT_HANDLE_WAITING_FAILED           0x0000000A2     // The waiting failed.
// function com_univ_handle_obtain_create_process()
#define COM_UNIV_ERR_HANDLE_OBTAIN_CREATE_PROCESS_CREATE_PROCESS        0x0000000C0     // Unable to create process.
// function com_univ_handle_obtain_open_process()
#define COM_UNIV_ERR_HANDLE_OBTAIN_OPEN_PROCESS_OPEN_PROCESS            0x0000000D0     // Unable to open process.
// function com_univ_handle_obtain_open_thread()
#define COM_UNIV_ERR_HANDLE_OBTAIN_OPEN_THREAD_OPEN_THREAD              0x0000000E0     // Unable to open thread.
// function com_univ_structure_alloc_write()
#define COM_UNIV_ERR_STRUCTURE_ALLOC_WRITE_VIRTUAL_ALLOC_EX             0x000000100     // Memory allocation failed.
#define COM_UNIV_ERR_STRUCTURE_ALLOC_WRITE_WRITE_PROCESS_MEMORY         0x000000101     // Unable to write data to the target process memory.
// function com_univ_infect_rewrite_entry()
#define COM_UNIV_ERR_INFECT_REWRITE_ENTRY_WRITE_PROCESS_MEMORY          0x000000120     // Unable to write data to the target process memory.
// function com_univ_structure_start_resume_thread()
#define COM_UNIV_ERR_STRUCTURE_START_RESUME_THREAD_RESUME_THREAD        0x000000140     // Unable to resume suspended thread.
// function com_univ_structure_start_create_remote_thread
#define COM_UNIV_ERR_STRUCTURE_START_CREATE_REMOTE_THREAD_CREATE_REMOTE_THREAD 0x000000150      // Unable to create remote thread.
// function com_univ_structure_start_set_context_thread
#define COM_UNIV_ERR_STRUCTURE_START_SET_CONTEXT_THREAD_SUSPEND_THREAD  0x000000160     // Unable to suspend thread.
#define COM_UNIV_ERR_STRUCTURE_START_SET_CONTEXT_THREAD_GET_THREAD_CONTEXT 0x000000161  // Unable to get thread's context.
#define COM_UNIV_ERR_STRUCTURE_START_SET_CONTEXT_THREAD_WRITE_PROCESS_MEMORY 0x000000162        // Unable to write data to the target process' memory.
#define COM_UNIV_ERR_STRUCTURE_START_SET_CONTEXT_THREAD_SET_THREAD_CONTEXT 0x000000163  // Unable to set thread's context.
#define COM_UNIV_ERR_STRUCTURE_START_SET_CONTEXT_THREAD_RESUME_THREAD   0x000000164     // Unable to resume thread.
// function com_univ_structure_cleanup_set_context_thread
#define COM_UNIV_ERR_STRUCTURE_CLEANUP_SET_CONTEXT_THREAD_SET_THREAD_CONTEXT 0x000000168        // Unable to set thread's context.
#define COM_UNIV_ERR_STRUCTURE_CLEANUP_SET_CONTEXT_THREAD_RESUME_THREAD 0x000000169     // Unable to resume thread.
// function com_univ_suspend_current_thread
#define COM_UNIV_ERR_SUSPEND_CURRENT_THREAD                             0x000000180     // Unable to suspend current thread.
// function com_univ_client_init()
#define COM_UNIV_ERR_CLIENT_INIT_OPEN_EVENT                             0x0000001C0     // Unable to open event.
#define COM_UNIV_ERR_CLIENT_INIT_OPEN_FILE_MAPPING                      0x0000001C1     // Unable to open file mapping.
#define COM_UNIV_ERR_CLIENT_INIT_MAP_VIEW_OF_FILE                       0x0000001C2     // Unable to map file mapping to the current process' address space.
// function com_univ_client_send_result()
#define COM_UNIV_ERR_CLIENT_SEND_RESULT_SET_EVENT                       0x000000200     // Unable to set event.
// function com_univ_client_send_result_error()
#define COM_UNIV_ERR_CLIENT_SEND_RESULT_ERROR_SET_EVENT                 0x000000204     // Unable to set event.
// function com_univ_inet_sock_http()
#define COM_UNIV_ERR_INET_SOCK_HTTP_WSASTARTUP                          0x000000240     // Unable to initiate Windows Sockets.
#define COM_UNIV_ERR_INET_SOCK_HTTP_SOCKET                              0x000000241     // Unable to create TCP socket.
#define COM_UNIV_ERR_INET_SOCK_HTTP_CONNECT                             0x000000242     // Unable to connect to the server.
#define COM_UNIV_ERR_INET_SOCK_HTTP_SEND                                0x000000243     // Unable to send data to the server.
#define COM_UNIV_ERR_INET_SOCK_HTTP_IOCTLSOCKET                         0x000000244     // Unable to get information from the socket.
#define COM_UNIV_ERR_INET_SOCK_HTTP_SELECT                              0x000000245     // Unable to wait for data from the server.
#define COM_UNIV_ERR_INET_SOCK_HTTP_RECV                                0x000000246     // Unable to receive  data from the server.
// function com_univ_inet_sock_dns()
#define COM_UNIV_ERR_INET_SOCK_DNS_WSASTARTUP                           0x000000280     // Unable to initiate Windows Sockets.
#define COM_UNIV_ERR_INET_SOCK_DNS_SOCKET                               0x000000281     // Unable to create UDP socket.
#define COM_UNIV_ERR_INET_SOCK_DNS_SENDTO                               0x000000282     // Unable to send data to the server.
#define COM_UNIV_ERR_INET_SOCK_DNS_SELECT                               0x000000283     // Unable to wait for data from the server.
#define COM_UNIV_ERR_INET_SOCK_DNS_RECVFROM                             0x000000284     // Unable to receive  data from the server.
// function com_univ_terminate_process()
#define COM_UNIV_ERR_TERMINATE_PROCESS_TERMINATE_PROCESS                0x0000002C0     // Unable to terminate process.

// maximum number of imports from second DLL
#define COM_UNIV_MAX_DLL_IMPORTS                16

// maximum length of second DLL name
#define COM_UNIV_MAX_DLL_NAME_LEN               16

// invalid job index
#define COM_UNIV_ERR_NO_JOB                     -1

// always execute the given action
#define COM_UNIV_JOB_ACTION_EXECUTE_ALWAYS      -1


// RVAs of important "kernel32.dll" functions
typedef struct COM_UNIV_FUNC_KERNEL32
{
  CLOSE_HANDLE CloseHandle;
  CREATE_PROCESS_A CreateProcessA;
  CREATE_REMOTE_THREAD CreateRemoteThread;
  EXIT_PROCESS ExitProcess;
  EXIT_THREAD ExitThread;
  GET_LAST_ERROR GetLastError;
  GET_THREAD_CONTEXT GetThreadContext;
  LOAD_LIBRARY_A LoadLibraryA;
  MAP_VIEW_OF_FILE MapViewOfFile;
  OPEN_EVENT_A OpenEventA;
  OPEN_FILE_MAPPING_A OpenFileMappingA;
  OPEN_PROCESS OpenProcess;
  OPEN_THREAD OpenThread;
  RESUME_THREAD ResumeThread;
  SET_EVENT SetEvent;
  SET_THREAD_CONTEXT SetThreadContext;
  SLEEP Sleep;
  SUSPEND_THREAD SuspendThread;
  TERMINATE_PROCESS TerminateProcess;
  UNMAP_VIEW_OF_FILE UnmapViewOfFile;
  VIRTUAL_ALLOC_EX VirtualAllocEx;
  VIRTUAL_FREE_EX VirtualFreeEx;
  WAIT_FOR_MULTIPLE_OBJECTS WaitForMultipleObjects;
  WRITE_PROCESS_MEMORY WriteProcessMemory;
} COM_UNIV_FUNC_KERNEL32,*PCOM_UNIV_FUNC_KERNEL32;

// RVAs of important "ws2_32.dll" functions
typedef struct COM_UNIV_FUNC_WS2_32
{
  CLOSESOCKET closesocket;
  CONNECT connect;
  IOCTLSOCKET ioctlsocket;
  RECV recv;
  RECVFROM recvfrom;
  SELECT select;
  SEND send;
  SENDTO sendto;
  SOCKETF socket;
  WSA_CLEANUP WSACleanup;
  WSA_STARTUP WSAStartup;
} COM_UNIV_FUNC_WS2_32,*PCOM_UNIV_FUNC_WS2_32;


// universal job stack items
typedef struct COM_UNIV_JOB_STACK_ITEM
{
  size_t size;                                  // size of items
  size_t data_offset;                           // offset of the data in stack buffer
} COM_UNIV_JOB_STACK_ITEM,*PCOM_UNIV_JOB_STACK_ITEM;

// universal job stack structure
typedef struct COM_UNIV_JOB_STACK
{
  size_t size_total;                            // total size of the stack in bytes
  size_t size_free;                             // number of free bytes in the stack buffer
  int top;                                      // index of the top stack item on the stack
  int max_items;                                // maximum number of items in the stack
  size_t items_offset;                          // relative offset of the array of stack items
  size_t buffer_offset;                         // relative offset of the stack data buffer
} COM_UNIV_JOB_STACK,*PCOM_UNIV_JOB_STACK;

// universal action structure
typedef struct COM_UNIV_ACTION
{
  int min_index;                                // the action is executed only if all actions up to the action with index='min_index' succeeded
                                                // value COM_UNIV_JOB_ACTION_EXECUTE_ALWAYS means that the action is always executed
  size_t func_offset;                           // a relative offset to the function that realizes the action
  int argument_present;                         // TRUE if the function has user defined argument, FALSE otherwise
  int argument;                                 // a value of the user defined argument
} COM_UNIV_ACTION,*PCOM_UNIV_ACTION;

// universal job structure
typedef struct COM_UNIV_JOB
{
  size_t size;                                  // size of the job in bytes
  int index;                                    // index of the job
  void *offset_base;                            // address of com_univ_code_block() in the process that will execute the job

  COM_UNIV_JOB_STACK stack;                     // stack for shared data between actions

  int actions_count;                            // number of items in 'actions' array
  COM_UNIV_ACTION actions[ANYSIZE_ARRAY];       // list of universal actions
  // COM_UNIV_JOB_STACK_ITEM stack_items[ANYSIZE_ARRAY]; // stack items
  // char stack_data[ANYSIZE_ARRAY];            // stack data
} COM_UNIV_JOB,*PCOM_UNIV_JOB;


// universal error information
typedef struct COM_UNIV_ERROR
{
  int occurred;                                 // TRUE if error occurred, FALSE otherwise
  DWORD code_system;                            // system error code
  DWORD code;                                   // universal error code
  int job_index;                                // index of the job in which the error occurred or COM_UNIV_ERR_NO_JOB for no job
} COM_UNIV_ERROR,*PCOM_UNIV_ERROR;

// universal client-to-server data
typedef struct COM_UNIV_DATA
{
  COM_UNIV_ERROR error;                         // error information
  char buffer[COM_MAP_DEFAULT_DATA_BUFFER_SIZE_MAX];   // message data
} COM_UNIV_DATA,*PCOM_UNIV_DATA;

// common mapping support data
typedef struct COM_UNIV_MAPPING
{
  HANDLE event;                                 // synchronization event handle
  HANDLE mapping;                               // mapping handle
  PCOM_UNIV_DATA data;                          // pointer to mapping in the current process
} COM_UNIV_MAPPING,*PCOM_UNIV_MAPPING;

struct COM_UNIV;

// prototypes of com_univ_job_stack_* functions
typedef int (*COM_UNIV_JOB_STACK_PUSH)(struct COM_UNIV *univ,PCOM_UNIV_JOB job,void *item_data,size_t item_size);
typedef int (*COM_UNIV_JOB_STACK_POP)(struct COM_UNIV *univ,PCOM_UNIV_JOB job,void **item_data,size_t *item_size);
typedef int (*COM_UNIV_JOB_STACK_GET)(struct COM_UNIV *univ,PCOM_UNIV_JOB job,int item_index,void **item_data,size_t *item_size);


// universal testing structure
typedef struct COM_UNIV
{
  size_t size;                                  // total size of universal structure

  COM_UNIV_ERROR error;                         // error information

  size_t code_block_offset;                     // relative address of 'code_block' item

  COM_UNIV_MAPPING server_mapping;              // mapping used for a communication between attacker and target process
  char mapping_name[COM_EVENT_NAME_MAX_LEN];    // name of the file mapping
  char mapping_event_name[COM_MAPPING_NAME_MAX_LEN];    // name of the synchronization event

  COM_UNIV_JOB_STACK_PUSH job_stack_push;       // a pointer to com_univ_job_stack_push()
  COM_UNIV_JOB_STACK_POP job_stack_pop;         // a pointer to com_univ_job_stack_pop()
  COM_UNIV_JOB_STACK_GET job_stack_get;         // a pointer to com_univ_job_stack_get()

  size_t kernel32_offsets[sizeof(COM_UNIV_FUNC_KERNEL32)/sizeof(void*)];        // offsets of important "kernel32.dll" functions
  COM_UNIV_FUNC_KERNEL32 kernel32;              // pointers to important "kernel32.dll" functions

  char second_dll_name[COM_UNIV_MAX_DLL_NAME_LEN];      // the name of the second DLL
  int second_dll_func_count;                    // number of
  _ANONYMOUS_UNION union
  {
    size_t second_dll_offsets[COM_UNIV_MAX_DLL_IMPORTS];        // offsets of the second DLL functions
    size_t ws2_32_offsets[sizeof(COM_UNIV_FUNC_WS2_32)/sizeof(void*)];  // offsets of important "ws2_32.dll" functions
  } DUMMYUNIONNAME;

  _ANONYMOUS_UNION union
  {
    PVOID second_dll_pointers[COM_UNIV_MAX_DLL_IMPORTS];        // pointers to the second DLL functions
    COM_UNIV_FUNC_WS2_32 ws2_32;                // pointers to important "ws2_32.dll" functions
  } DUMMYUNIONNAME;

  int job_index;                                // index of the current job, -1 for init
  int jobs_count;                               // number of jobs in the universal structure, number of items in 'jobs' array
  size_t jobs_offset[ANYSIZE_ARRAY];            // array of offsets of jobs in 'jobs_items' array

  // COM_UNIV_JOB jobs_items[ANYSIZE_ARRAY];    // variable length structures of jobs
  // char code_block[ANYSIZE_ARRAY];            // block with functions' code
} COM_UNIV,*PCOM_UNIV;


/*
 An universal action function prototype.

 'univ' A pointer to the universal structure.
 'job' A pointer to the universal job.

 If the function succeeds the return value is TRUE, otherwise it is FALSE.
 If the function fails, the error related values inside 'univ' structure are filled properly.
*/

typedef int WINAPI (*COM_UNIV_ACTION_FUNC)(PCOM_UNIV univ,PCOM_UNIV_JOB job);


/*
 An universal action function prototype with a user argument.

 'univ' A pointer to the universal structure.
 'job' A pointer to the universal job.
 'arg' A user defined argument.

 If the function succeeds the return value is TRUE, otherwise it is FALSE.
 If the function fails, the error related values inside 'univ' structure are filled properly.
*/

typedef int WINAPI (*COM_UNIV_ACTION_FUNC_ARG)(PCOM_UNIV univ,PCOM_UNIV_JOB job,int arg);




int com_univ_init(ULONG flags,char *name,int jobs_count,PCOM_UNIV_JOB *jobs,PCOM_UNIV *univ,PCOM_ERROR err_inf);
void com_univ_finit(PCOM_UNIV univ);
int com_univ_job_init(int actions_count,size_t stack_size,int stack_items_count,PCOM_UNIV_JOB *job,PCOM_ERROR err_inf);
void com_univ_job_finit(PCOM_UNIV_JOB job);
void com_univ_job_action_set(PCOM_UNIV_JOB job,int action_idx,int min_action,COM_UNIV_ACTION_FUNC func);
void com_univ_job_action_set_arg(PCOM_UNIV_JOB job,int action_idx,int min_action,COM_UNIV_ACTION_FUNC_ARG func,int arg);

void com_univ_code_block(void);
int com_univ_job_stack_push(PCOM_UNIV univ,PCOM_UNIV_JOB job,void *item_data,size_t item_size);
int com_univ_job_stack_pop(PCOM_UNIV univ,PCOM_UNIV_JOB job,void **item_data,size_t *item_size);
int com_univ_job_stack_get(PCOM_UNIV univ,PCOM_UNIV_JOB job,int item_index,void **item_data,size_t *item_size);
int WINAPI com_univ_job_stack_push_copy(PCOM_UNIV univ,PCOM_UNIV_JOB job,int item_index);
int WINAPI com_univ_load_second_dll(PCOM_UNIV univ,PCOM_UNIV_JOB job);
int WINAPI com_univ_job_stack_remove(PCOM_UNIV univ,PCOM_UNIV_JOB job);
int WINAPI com_univ_handle_obtain_create_process(PCOM_UNIV univ,PCOM_UNIV_JOB job);
int WINAPI com_univ_handle_obtain_open_process(PCOM_UNIV univ,PCOM_UNIV_JOB job);
int WINAPI com_univ_handle_obtain_open_thread(PCOM_UNIV univ,PCOM_UNIV_JOB job);
int WINAPI com_univ_handle_close(PCOM_UNIV univ,PCOM_UNIV_JOB job);
int WINAPI com_univ_structure_alloc_write(PCOM_UNIV univ,PCOM_UNIV_JOB job);
int WINAPI com_univ_structure_start_resume_thread(PCOM_UNIV univ,PCOM_UNIV_JOB job);
int WINAPI com_univ_structure_start_create_remote_thread(PCOM_UNIV univ,PCOM_UNIV_JOB job);
int WINAPI com_univ_structure_start_set_context_thread(PCOM_UNIV univ,PCOM_UNIV_JOB job);
int WINAPI com_univ_structure_cleanup_set_context_thread(PCOM_UNIV univ,PCOM_UNIV_JOB job);
int WINAPI com_univ_infect_rewrite_entry(PCOM_UNIV univ,PCOM_UNIV_JOB job);
int WINAPI com_univ_suspend_current_thread(PCOM_UNIV univ,PCOM_UNIV_JOB job);
int WINAPI com_univ_client_init(PCOM_UNIV univ,PCOM_UNIV_JOB job);
int WINAPI com_univ_client_finit(PCOM_UNIV univ,PCOM_UNIV_JOB job);
int WINAPI com_univ_client_send_result(PCOM_UNIV univ,PCOM_UNIV_JOB job);
int WINAPI com_univ_client_send_result_error(PCOM_UNIV univ,PCOM_UNIV_JOB job);
int WINAPI com_univ_wait_mapping_event_handle(PCOM_UNIV univ,PCOM_UNIV_JOB job);
int WINAPI com_univ_inet_sock_http(PCOM_UNIV univ,PCOM_UNIV_JOB job);
int WINAPI com_univ_inet_sock_dns(PCOM_UNIV univ,PCOM_UNIV_JOB job);
int WINAPI com_univ_terminate_process(PCOM_UNIV univ,PCOM_UNIV_JOB job);
int WINAPI com_univ_server_init(PCOM_UNIV univ,PCOM_UNIV_JOB job) __attribute__((noinline));
int WINAPI com_univ_server_finit(PCOM_UNIV univ,PCOM_UNIV_JOB job) __attribute__((noinline));
DWORD WINAPI com_univ_main(PCOM_UNIV univ);
void com_univ_code_block_end(void);

int com_univ_job_stack_init_push(PCOM_UNIV_JOB job,void *item_data,size_t item_size);

int com_univ_server_init_external(PCOM_UNIV univ,PCOM_UNIV_JOB job);
int com_univ_server_finit_external(PCOM_UNIV univ,PCOM_UNIV_JOB job);

void com_univ_inet_sock_http_init(struct sockaddr_in *host,char *data,size_t len,PCOM_CONF conf);

void com_univ_server_err_report(PCOM_UNIV univ,PCOM_ERROR err_inf);


#endif
