/*

 Security Software Testing Suite - Shared code library for spying tests
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/

*/

#include <windows.h>
#include <conio.h>
#include <stdio.h>
#include "common.h"
#include "common-spy.h"


int com_spy_data_init(PCOM_SPY_DATA kd,PCOM_CONF conf,PCOM_ERROR err_inf);
void com_spy_data_finit(PCOM_SPY_DATA kd);
int com_spy_print_and_check_input(char chr,PCOM_SPY_DATA kd);
void com_spy_wait(PCOM_SPY_DATA kd,HANDLE thread);



/*
 Initializes data structure for the spying tests.

 'kd' A pointer to the spying tests structure.
 'conf' A pointer to a structure to which the configuration is loaded.
 'err_inf' A pointer to a structure that will be filled with an error message and a code if an error occurs.

 The return value is TRUE if the function was successful, FALSE otherwise.
*/

int com_spy_data_init(PCOM_SPY_DATA kd,PCOM_CONF conf,PCOM_ERROR err_inf)
{
  int res=FALSE;

  kd->conf=conf;
  kd->err_inf=err_inf;
  kd->res=FALSE;
  kd->event=CreateEvent(NULL,TRUE,FALSE,NULL);
  if (kd->event) res=TRUE;
  else com_err_set(kd->err_inf,"Unable to create event.\n");

  return res;
}


/*
 Frees resources used by a spying tests structure.

 'kd' A pointer to the spying tests structure.

 The return value is TRUE if the pattern was intercepted, FALSE otherwise.
*/

void com_spy_data_finit(PCOM_SPY_DATA kd)
{
  CloseHandle(kd->event);

  return;
}


/*
 Recieves a character and checks if a pattern has been already recieved.
 This function is used by keyloggers.

 'chr' charracter which is to be appended.
 'kd' structure which contains data.

 The return value is TRUE if the buffer is full or the pattern was found. Otherwise it is FALSE.
*/

int com_spy_print_and_check_input(char chr,PCOM_SPY_DATA kd)
{
  if (chr==VK_RETURN) printf("\n");
  else printf("%c",chr);

  int res=FALSE;

  if (chr)
  {
    int len=strlen(kd->conf->data);
    char *buf=kd->conf->data;
    if (len+2<sizeof(kd->conf->data))
    {
      buf[len++]=chr;
      buf[len]='\0';

      int idx=len-strlen(kd->conf->magic);

      if ((idx>=0) && (!stricmp(&buf[idx],kd->conf->magic)))
      {
        printf("\nPattern found!\n");
        kd->res=TRUE;
        if (!SetEvent(kd->event)) com_err_set(kd->err_inf,"Unable to signal event.\n");

        res=TRUE;
      }
    } else
    {
      com_err_set_nc(kd->err_inf,"Too many keystrokes intercepted. Buffer has not sufficient size.\n");
      res=TRUE;
    }
  }

  return res;
}


/*
 Waits until a key in the console window is pressed or until the synchronization event is signaled.

 'kd' A pointer to the spying tests structure.
 'thread' A handle of the executive thread.
*/

void com_spy_wait(PCOM_SPY_DATA kd,HANDLE thread)
{
  int done=FALSE;
  int terminate_thread=TRUE;

  while (!done)
  {
    if (_kbhit())
    {
      if (SetEvent(kd->event)) terminate_thread=FALSE;
      else com_err_set(kd->err_inf,"Unable to signal event.\n");

      _getch();
      printf("\n");
      break;
    }

    HANDLE objs[2]={kd->event,thread};
    DWORD wres=WaitForMultipleObjects(2,objs,FALSE,10);
    switch (wres)
    {
      case WAIT_TIMEOUT:
        break;

      case WAIT_OBJECT_0:
      case WAIT_OBJECT_0+1:
        terminate_thread=FALSE;
        done=TRUE;
        break;

      default:
        if (wres!=WAIT_FAILED) SetLastError(ERROR_SUCCESS);
        com_err_set_print_clear(kd->err_inf,COM_ERR_STANDARD_PREFIX,"Unknown error occurred, WaitForSingleObject returned %ld.\n",wres);

        done=TRUE;

        if (SetEvent(kd->event)) terminate_thread=FALSE;
        else com_err_set(kd->err_inf,"Unable to signal event.\n");
        break;
    }
  }

  if (terminate_thread) TerminateThread(thread,1);
  WaitForSingleObject(thread,5000);

  return;
}
