/*

 Active Desktop support header for Security Software Testing Suite
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/

*/

#ifndef __ACTIVEDESKTOP_HPP__
#define __ACTIVEDESTKOP_HPP__

#ifdef __cplusplus
extern "C" {
#endif

#include <oaidl.h>
#include <ocidl.h>
#include <docobj.h>


#define AD_APPLY_SAVE             0x00000001
#define AD_APPLY_HTMLGEN          0x00000002
#define AD_APPLY_REFRESH          0x00000004
#define AD_APPLY_ALL              (AD_APPLY_SAVE | AD_APPLY_HTMLGEN | AD_APPLY_REFRESH)
#define AD_APPLY_FORCE            0x00000008
#define AD_APPLY_BUFFERED_REFRESH 0x00000010
#define AD_APPLY_DYNAMICREFRESH   0x00000020


typedef struct _tagWALLPAPEROPT
{
  DWORD dwSize;
  DWORD dwStyle;
}
WALLPAPEROPT;

typedef WALLPAPEROPT  *LPWALLPAPEROPT;
typedef const WALLPAPEROPT *LPCWALLPAPEROPT;

typedef struct _tagCOMPONENTSOPT
{
  DWORD dwSize;
  BOOL fEnableComponents;
  BOOL fActiveDesktop;
}
COMPONENTSOPT;

typedef COMPONENTSOPT   *LPCOMPONENTSOPT;
typedef const COMPONENTSOPT   *LPCCOMPONENTSOPT;

typedef struct _tagCOMPPOS
{
  DWORD dwSize;
  int iLeft;
  int iTop;
  DWORD dwWidth;
  DWORD dwHeight;
  int izIndex;
  BOOL fCanResize;
  BOOL fCanResizeX;
  BOOL fCanResizeY;
  int iPreferredLeftPercent;
  int iPreferredTopPercent;
}
COMPPOS;

typedef COMPPOS *LPCOMPPOS;
typedef const COMPPOS *LPCCOMPPOS;

typedef struct  _tagCOMPSTATEINFO
{
  DWORD dwSize;
  int iLeft;
  int iTop;
  DWORD dwWidth;
  DWORD dwHeight;
  DWORD dwItemState;
}
COMPSTATEINFO;

typedef COMPSTATEINFO   *LPCOMPSTATEINFO;
typedef const COMPSTATEINFO *LPCCOMPSTATEINFO;


typedef struct _tagCOMPONENT
{
  DWORD dwSize;
  DWORD dwID;
  int iComponentType;
  BOOL fChecked;
  BOOL fDirty;
  BOOL fNoScroll;
  COMPPOS cpPos;
  WCHAR wszFriendlyName[MAX_PATH];
  WCHAR wszSource[INTERNET_MAX_URL_LENGTH];
  WCHAR wszSubscribedURL[INTERNET_MAX_URL_LENGTH];

  DWORD dwCurItemState;
  COMPSTATEINFO csiOriginal;
  COMPSTATEINFO siRestored;
}
COMPONENT;

typedef COMPONENT *LPCOMPONENT;
typedef const COMPONENT *LPCCOMPONENT;



#undef INTERFACE
#define INTERFACE IActiveDesktop

DECLARE_INTERFACE_( IActiveDesktop, IUnknown )
{
  STDMETHOD (QueryInterface)(THIS_ REFIID riid, void **ppv) PURE;
  STDMETHOD_(ULONG, AddRef) ( THIS ) PURE;
  STDMETHOD_(ULONG, Release) ( THIS ) PURE;
  STDMETHOD (ApplyChanges)(THIS_ DWORD dwFlags) PURE;
  STDMETHOD (GetWallpaper)(THIS_ LPWSTR pwszWallpaper, UINT cchWallpaper, DWORD dwReserved) PURE;
  STDMETHOD (SetWallpaper)(THIS_ LPCWSTR pwszWallpaper, DWORD dwReserved) PURE;
  STDMETHOD (GetWallpaperOptions)(THIS_ LPWALLPAPEROPT pwpo, DWORD dwReserved) PURE;
  STDMETHOD (SetWallpaperOptions)(THIS_ LPCWALLPAPEROPT pwpo, DWORD dwReserved) PURE;
  STDMETHOD (GetPattern)(THIS_ LPWSTR pwszPattern, UINT cchPattern, DWORD dwReserved) PURE;
  STDMETHOD (SetPattern)(THIS_ LPCWSTR pwszPattern, DWORD dwReserved) PURE;
  STDMETHOD (GetDesktopItemOptions)(THIS_ LPCOMPONENTSOPT pco, DWORD dwReserved) PURE;
  STDMETHOD (SetDesktopItemOptions)(THIS_ LPCCOMPONENTSOPT pco, DWORD dwReserved) PURE;
  STDMETHOD (AddDesktopItem)(THIS_ LPCCOMPONENT pcomp, DWORD dwReserved) PURE;
  STDMETHOD (AddDesktopItemWithUI)(THIS_ HWND hwnd, LPCOMPONENT pcomp, DWORD dwReserved) PURE;
  STDMETHOD (ModifyDesktopItem)(THIS_ LPCCOMPONENT pcomp, DWORD dwFlags) PURE;
  STDMETHOD (RemoveDesktopItem)(THIS_ LPCCOMPONENT pcomp, DWORD dwReserved) PURE;
  STDMETHOD (GetDesktopItemCount)(THIS_ LPINT lpiCount, DWORD dwReserved) PURE;
  STDMETHOD (GetDesktopItem)(THIS_ int nComponent, LPCOMPONENT pcomp, DWORD dwReserved) PURE;
  STDMETHOD (GetDesktopItemByID)(THIS_ ULONG_PTR dwID, LPCOMPONENT pcomp, DWORD dwReserved) PURE;
  STDMETHOD (GenerateDesktopItemHtml)(THIS_ LPCWSTR pwszFileName, LPCOMPONENT pcomp, DWORD dwReserved) PURE;
  STDMETHOD (AddUrl)(THIS_ HWND hwnd, LPCWSTR pszSource, LPCOMPONENT pcomp, DWORD dwFlags) PURE;
  STDMETHOD (GetDesktopItemBySource)(THIS_ LPCWSTR pwszSource, LPCOMPONENT pcomp, DWORD dwReserved) PURE;
};

typedef IActiveDesktop * LPACTIVEDESKTOP;

const IID CLSID_ActiveDesktop   = {0x75048700, 0xEF1F, 0x11D0, {0x98, 0x88, 0x00, 0x60, 0x97, 0xDE, 0xAC, 0xF9}};
const IID IID_IActiveDesktop    = {0xF490EB00, 0x1240, 0x11D1, {0x98, 0x88, 0x00, 0x60, 0x97, 0xDE, 0xAC, 0xF9}};


#ifdef __cplusplus
}
#endif

#endif
