/*

 Security Software Testing Suite - Ghost (leak-test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * Based on the original code and idea of Ghost by Guillaume Kaddouch, http://www.firewallleaktester.com/.
     Guillaume Kaddouch kindly provided us a part of the source code of Ghost.


 Method description:

   * Execute a second instance of this test.

   * Execute Internet Explorer with a URL as a command line parameter. This URL parameter,
     which also contains the data to transmit, redirects Internet Explorer to the Internet webpage.

   * Terminates itself as soon as possible.

*/

#include <stdio.h>
#include <windows.h>
#include <wininet.h>
#include "include/common.h"
#include "include/common-leak.h"
#include "include/common-hook.h"


int main(int argc,char **argv)
{
  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  COM_CONF conf;
  DWORD ppid;
  char pname[MAX_PATH];
  if (com_get_parent_info(GetCurrentProcessId(),&ppid,pname,sizeof(pname),&err_inf))
  {
    if ((pname[0]=='\0') || (!stricmp(pname,"ghost.exe")))       // if parent is this test
    {
      if (!com_console_init_main_no_about("Ghost","ghost",argc,argv,&conf,COM_TEST_TYPE_GHOST)) return 1;

      printf("\n\n");
      char buffer[4096];
      res=com_attempt_check_ie_cache(buffer,sizeof(buffer),&conf,10000,&err_inf)
       && com_find_pattern_and_print_data(buffer,sizeof(buffer),&conf,&err_inf);

    } else
    {
      char *credits=" * Based on the original code and idea of Ghost by Guillaume Kaddouch,\n"
                    "   who kindly provided us a part of the source code of Ghost.\n"
                    "   http://www.firewallleaktester.com/\n";

      if (!com_console_init_main_with_credits("Ghost","ghost",argc,argv,&conf,COM_TEST_TYPE_GHOST,credits)) return 1;

      char *used_dlls[]={"ntdll.dll","kernel32.dll"};
      if (!com_hook_load_libraries(used_dlls,2)) return 1;

      DeleteUrlCacheEntry(conf.uri);

      char imagepath[MAX_PATH];

      if (com_get_ie_path(imagepath,sizeof(imagepath),&err_inf))
      {
        if (com_verbosity_get()) printf("Internet Explorer's path set to \"%s\".\n",imagepath);

        char cmdline[MAX_PATH+COM_INET_URI_MAX_LEN];
        snprintf(cmdline,sizeof(cmdline),"\"%s\" \"%s\"",imagepath,conf.uri);
        cmdline[sizeof(cmdline)-1]='\0';
        if (com_verbosity_get()) printf("Command line for the new Internet Explorer's process set to \"%s\".\n",cmdline);

        STARTUPINFO si;
        PROCESS_INFORMATION pi;
        memset(&si,0,sizeof(si));
        si.cb=sizeof(si);
        si.dwFlags=STARTF_USESTDHANDLES;
        si.hStdInput=GetStdHandle(STD_INPUT_HANDLE);
        si.hStdOutput=GetStdHandle(STD_OUTPUT_HANDLE);
        si.hStdError=GetStdHandle(STD_ERROR_HANDLE);

        if (CreateProcess(NULL,argv[0],NULL,NULL,FALSE,0,NULL,NULL,&si,&pi))
        {
          CloseHandle(pi.hProcess);
          CloseHandle(pi.hThread);

          STARTUPINFO si2;
          PROCESS_INFORMATION pi2;
          memset(&si2,0,sizeof(si2));
          si2.cb=sizeof(si2);

          if (CreateProcess(NULL,cmdline,NULL,NULL,FALSE,0,NULL,NULL,&si2,&pi2))
          {
            CloseHandle(pi2.hProcess);
            CloseHandle(pi2.hThread);
          } else com_err_set(&err_inf,"Unable to create child process \"%s\".\n",imagepath);

          return 0;
        } else com_err_set(&err_inf,"Unable to create child process \"%s\".\n",argv[0]);
      }
    }
  }

  return com_end(res,&err_inf,&conf);
}
