/*

 Security Software Testing Suite - Flank (leak-test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * This technique is used by PC Flank Leaktest, written by PC Flank Ltd., http://www.pcflank.com/.


 Method description:

   * Use IWebBrowser2 hosted by Internet Explorer to control an instance of Internet explorer
     to make it send and receive the data from the Internet.

   * The interface is documented in MSDN: http://msdn2.microsoft.com/en-us/library/aa752127.aspx

*/

#include <windows.h>
#include <stdio.h>
#include <objbase.h>
#include <exdisp.h>
#include <shlguid.h>
#include <mshtml.h>
#include "include/common.h"
#include "include/common-hook.h"


int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow)
{
  COM_CONF conf;
  if (!com_console_init_winmain("Flank","flank",lpCmdLine,&conf,COM_TEST_TYPE_FLANK)) return 1;

  char *used_dlls[]={"ole32.dll","oleaut32.dll"};
  if (!com_hook_load_libraries(used_dlls,2)) return 1;

  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  HRESULT hres=CoInitialize(NULL);
  if (SUCCEEDED(hres))
  {
    IWebBrowser2 *wb=NULL;
    hres=CoCreateInstance(CLSID_InternetExplorer,NULL,CLSCTX_LOCAL_SERVER,IID_IWebBrowser2,(void**)&wb);

    if (SUCCEEDED(hres))
    {
      if (com_verbosity_get()) printf("IWebBrowser2 instance created.\n");

      wchar_t wuri[COM_INET_URI_MAX_LEN];
      snwprintf(wuri,sizeof(wuri)/sizeof(wchar_t),L"%S",conf.uri);
      wuri[sizeof(wuri)/sizeof(wchar_t)-1]=L'\0';

      BSTR buri=SysAllocString(wuri);
      if (buri)
      {
        VARIANT var,flags;
        var.vt=VT_EMPTY;
        flags.vt=VT_I1;
        flags.iVal=navNoHistory | navNoReadFromCache  | navNoWriteTocache;

        hres=wb->Navigate(buri,&flags,&var,&var,&var);
        if (SUCCEEDED(hres))
        {
          if (com_verbosity_get()) printf("IWebBrowser2 navigated to \"%s\".\n",conf.uri);

          READYSTATE ready;
          int timeout=20000;

          while ((timeout>0) && (ready!=READYSTATE_COMPLETE))
          {
            hres=wb->get_ReadyState(&ready);
            if (!SUCCEEDED(hres)) break;
            Sleep(100);
            timeout-=100;
          }

          if ((timeout>0) && SUCCEEDED(hres))
          {
            if (com_verbosity_get()) printf("IWebBrowser2 finished download.\n");

            IDispatch *disp=NULL;
            hres=wb->get_Document(&disp);
            if (SUCCEEDED(hres))
            {
              if (com_verbosity_get()) printf("IWebBrowser2 document retrieved.\n");

              IHTMLDocument2 *doc=NULL;
              hres=disp->QueryInterface(IID_IHTMLDocument2,(void**)&doc);
              if (SUCCEEDED(hres))
              {
                if (com_verbosity_get()) printf("IHTMLDocument2 document retrieved.\n");

                IHTMLElement *body=NULL;
                hres=doc->get_body(&body);
                if (SUCCEEDED(hres))
                {
                  if (com_verbosity_get()) printf("IHTMLDocument2 body retrieved.\n");

                  BSTR data=NULL;
                  hres=body->get_innerHTML(&data);
                  if (SUCCEEDED(hres) && data)
                  {
                    if (com_verbosity_get()) printf("IHTMLDocument2 body innerHTML retrieved.\n");

                    char buffer[4096];
                    memset(buffer,0,sizeof(buffer));
                    WideCharToMultiByte(CP_ACP,WC_COMPOSITECHECK,data,-1,buffer,sizeof(buffer),NULL,NULL);
                    buffer[sizeof(buffer)-1]='\0';
                    printf("\n");
                    res=com_find_pattern_and_print_data(buffer,sizeof(buffer),&conf,&err_inf);

                    SysFreeString(data);
                  } else com_err_set_sc(&err_inf,HRESULT_CODE(hres),"Unable to get inner text of the body element.\n");

                  body->Release();
                } else com_err_set_sc(&err_inf,HRESULT_CODE(hres),"Unable to get body element from IHTMLDocument2.\n");

                doc->Release();
              } else com_err_set_sc(&err_inf,HRESULT_CODE(hres),"Unable to query active document interface to get IHTMLDocument2.\n");

              disp->Release();
            } else com_err_set_sc(&err_inf,HRESULT_CODE(hres),"Unable to get active document object from the IWebBrowser2 instance.\n");
          } else if (!SUCCEEDED(hres)) com_err_set_sc(&err_inf,HRESULT_CODE(hres),"Unable to get ready state of the IWebBrowser2 instance.\n");
          else com_err_set_nc(&err_inf,"Browser did not finish the task in reasonable time.\n");
        }

        SysFreeString(buri);
      } else com_err_set_nc(&err_inf,"Unable to allocate BSTR string for \"%s\".\n",conf.uri);

      wb->Release();
    } else com_err_set_sc(&err_inf,HRESULT_CODE(hres),"Unable to create instance of IWebBrowser2.\n");

    CoUninitialize();
  } else com_err_set_sc(&err_inf,HRESULT_CODE(hres),"Unable to initialize COM.\n");

  return com_end(res,&err_inf,&conf);
}
