/*

 Helper DLL for Security Software Testing Suite - FireHole (leak-test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/

 This DLL is loaded into the default browser and attempts to connect to the Internet server.

*/


#include <stdio.h>
#include <windows.h>
#include "include/common.h"
#include "include/common-leak.h"
#include "include/common-hook.h"


LRESULT CALLBACK CallWndRetProc(int nCode,WPARAM wParam,LPARAM lParam);
BOOL WINAPI DllMain(HINSTANCE hinstDLL,DWORD fdwReason,LPVOID lpvReserved);


/*
 Hook procedure that does nothing - all the work is done by DllMain().
 See 'lpfn' and 'idHook' parameters of SetWindowsHookEx API for more information.
*/

LRESULT CALLBACK CallWndRetProc(int nCode,WPARAM wParam,LPARAM lParam)
{
  return CallNextHookEx(NULL,nCode,wParam,lParam);
}


BOOL WINAPI DllMain(HINSTANCE hinstDLL,DWORD fdwReason,LPVOID lpvReserved)
{
  if (fdwReason==DLL_PROCESS_ATTACH)
  {
    char hostname[MAX_PATH];

    GetModuleFileName(NULL,hostname,sizeof(hostname));
    char *filename=strrchr(hostname,'\\');
    if (filename) filename++;
    else filename=hostname;

    COM_ERROR temp,*err_inf;
    char browser[MAX_PATH];
    if (com_get_default_browser_name(browser,sizeof(browser),&temp))
    {
      if (!stricmp(filename,browser))           // if in the default browser
      {
        COM_MAPPING map;
        COM_CONF conf;
        if (com_mapping_client_open(&map,COM_MAP_DEFAULT_DATA_SIZE_MAX,"FireHole",&conf,sizeof(conf),&temp))
        {
          err_inf=&map.data->error;
          com_attempt_wininet(map.data->buffer,sizeof(map.data->buffer),&conf,err_inf);

          SetEvent(map.event);

          com_mapping_close(&map);
        }
      }
    }
  }

  return TRUE;
}
