/*

 Security Software Testing Suite - ECHOtest (leak-test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * A similar technique is used by COMODO Outbound Connection Tests For Firewalls - ICMP 1,
     written by Comodo Group, http://www.comodo.com/.


 Method description:

   * Tries to send the data to the Internet server in ICMP ECHO request.

*/


#include <stdio.h>
#include <windows.h>
#include <winsock.h>
#include "include/common.h"
#include "include/common-hook.h"
#include "include/icmp.h"


/*
 IP checksum function.

 'addr' A pointer to IP packet.
 'len' Length of the packet in bytes.

 Returns IP checksum of the given packet.
*/

u_short checksum(u_short *addr,int len)
{
  int nleft=len,sum=0;
  u_short *w=addr;

  while (nleft>1)
  {
    sum+=*w++;
    nleft-=2;
  }

  if (nleft==1)
  {
    u_short u=0;
    *(u_char *)(&u)=*(u_char *)w;
    sum+=u;
  }

  sum=(sum >> 16)+(sum & 0xffff);
  sum+=(sum >> 16);
  u_short sumw=~sum;
  return sumw;
}


int main(int argc,char **argv)
{
  COM_CONF conf;
  if (!com_console_init_main("ECHOtest","echotest",argc,argv,&conf,COM_TEST_TYPE_ECHOTEST)) return 1;

  char *used_dlls[]={"ws2_32.dll"};
  if (!com_hook_load_libraries(used_dlls,1)) return 1;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  int res=FALSE;

  char ip_str[32];
  lstrcpynA(ip_str,inet_ntoa(conf.ip),sizeof(ip_str));

  WSADATA wsadata;
  int err=WSAStartup(MAKEWORD(1,1),&wsadata);
  if (!err)
  {
    if (com_verbosity_get()) printf("Creating RAW socket ...\n");
    SOCKET s=socket(AF_INET,SOCK_RAW,IPPROTO_ICMP);
    if (s!=INVALID_SOCKET)
    {
      if (com_verbosity_get()) printf("Socket 0x%X created.\n",s);

      SOCKADDR_IN sa;
      sa.sin_family=AF_INET;
      sa.sin_addr.s_addr=conf.ip.s_addr;
      sa.sin_port=0;

      char *buffer=malloc(ICMP_MAX_PACKET_SIZE);
      if (buffer)
      {
        memset(buffer,0,sizeof(buffer));
        PECHO_REQUEST icmp_req=(PECHO_REQUEST)buffer;

        icmp_req->icmp_hdr.type=ICMP_ECHO_REQUEST;
        icmp_req->icmp_hdr.code=0;
        icmp_req->icmp_hdr.checksum=0;
        icmp_req->icmp_hdr.id=1;
        icmp_req->icmp_hdr.seq=1;

        icmp_req->time=GetTickCount();
        snprintf(icmp_req->data,ICMP_MAX_PACKET_SIZE-sizeof(ECHO_REQUEST),"%s|%s",conf.data,conf.magic);
        icmp_req->data[ICMP_MAX_PACKET_SIZE-sizeof(ECHO_REQUEST)-1]='\0';

        size_t len=sizeof(ECHO_REQUEST)+strlen(icmp_req->data);

        icmp_req->icmp_hdr.checksum=checksum((u_short *)icmp_req,len);

        if (com_verbosity_get()) printf("Sending ICMP ECHO request to %s.\n",ip_str);

        int ret=sendto(s,(char *)icmp_req,len,0,(SOCKADDR *)&sa,sizeof(sa));
        if (ret!=SOCKET_ERROR)
        {
          if (com_verbosity_get()) printf("Waiting for response ...\n");

          FD_SET readfds;
          readfds.fd_count=1;
          readfds.fd_array[0]=s;

          TIMEVAL timeout;
          timeout.tv_sec=5;
          timeout.tv_usec=0;

          ret=select(1,&readfds,NULL,NULL,&timeout);
          if (ret==1)
          {
            memset(buffer,0,sizeof(buffer));
            PECHO_REPLY icmp_rep=(PECHO_REPLY)buffer;

            SOCKADDR_IN sa_src;
            size_t sa_len=sizeof(sa_src);
            ret=recvfrom(s,(char *)icmp_rep,ICMP_MAX_PACKET_SIZE,0,(SOCKADDR *)&sa_src,&sa_len);
            if (ret!=SOCKET_ERROR)
            {
              int delta=GetTickCount()-icmp_rep->req.time;
              res=strstr(icmp_rep->req.data,conf.magic)!=NULL;
              if (res) printf("Response received in %d ms.\n",delta);
              else com_err_set_nc(&err_inf,"Magic pattern not found.\n");
            } else com_err_set(&err_inf,"Unable to receive data from %s.\n",ip_str);
          } else if (ret==SOCKET_ERROR) com_err_set(&err_inf,"Unable to wait for data from %s.\n",ip_str);
          else com_err_set(&err_inf,"Waiting for data from %s timed out.\n",ip_str);
        } else com_err_set(&err_inf,"Unable to send data to %s.\n",ip_str);

        free(buffer);
      } else com_err_set(&err_inf,"Unable to allocate %d bytes of memory.\n",ICMP_MAX_PACKET_SIZE);

      closesocket(s);
    } else com_err_set(&err_inf,"Unable to create socket.\n");

    WSACleanup();
  } else com_err_set_sc(&err_inf,err,"Unable to initialize Windows Sockets.\n");

  return com_end(res,&err_inf,&conf);
}
