/*

 Security Software Testing Suite - DDEtest (leak-test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * Inspired by the idea and code of Surfer by Jarkko Turkulainen, http://www.klake.org/.


 Method description:

   * Internet Explorer must be running.

   * Use DDE to connect to "Iexplore" DDE server with "WWW_OpenURL" topic.

   * Request Internet Explorer using DDE to open a URL that contains the data to transfer.

*/


#include <stdio.h>
#include <windows.h>
#include <wininet.h>
#include "include/common.h"
#include "include/common-leak.h"
#include "include/common-hook.h"


int main(int argc,char *argv[])
{
  COM_CONF conf;
  if (!com_console_init_main("DDEtest","ddetest",argc,argv,&conf,COM_TEST_TYPE_DDETEST)) return 1;

  char *used_dlls[]={"user32.dll","ole32.dll","oleaut32.dll"};
  if (!com_hook_load_libraries(used_dlls,3)) return 1;

  DeleteUrlCacheEntry(conf.uri);

  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  DWORD pid;
  if (com_get_ie_pid_wait(&pid,&err_inf))
  {
    char buffer[4096];
    if (com_attempt_dde(&conf,10000,&err_inf))
      if (com_attempt_check_ie_cache(buffer,sizeof(buffer),&conf,15000,&err_inf))
        res=com_find_pattern_and_print_data(buffer,sizeof(buffer),&conf,&err_inf);
  }

  return com_end(res,&err_inf,&conf);
}
