/*

 Helper DLL for Security Software Testing Suite - CPILSuite3 (leak-test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/

 This DLL is loaded into Windows Explorer and its callback function WinEventProc() is executed.
 When this DLL is loaded it starts a new instance if Internet Explorer and redirects it to the URL
 read from the mapping.

*/


#include <stdio.h>
#include <windows.h>
#include "include/common.h"
#include "include/common-leak.h"


VOID CALLBACK WinEventProc(HWINEVENTHOOK hWinEventHook,DWORD event,HWND hwnd,LONG idObject,LONG idChild,DWORD dwEventThread,DWORD dwmsEventTime);
DWORD WINAPI run_browser(PVOID arg);
BOOL WINAPI DllMain(HINSTANCE hinstDLL,DWORD fdwReason,LPVOID lpvReserved);


/*
 Event hook function that does nothing - all the work is done by DllMain().
 See 'lpfnWinEventProc' parameter of SetWinEventHook API for more information.
*/

VOID CALLBACK WinEventProc(HWINEVENTHOOK hWinEventHook,DWORD event,HWND hwnd,LONG idObject,LONG idChild,DWORD dwEventThread,DWORD dwmsEventTime)
{
  return;
}


/*
 Thread routine that creates an instance of Internet Explorer and redirects it using DDE
 to a desired URL.
*/

DWORD WINAPI run_browser(PVOID arg)
{
  COM_ERROR temp,*err_inf;
  COM_MAPPING map;
  COM_CONF conf;
  if (com_mapping_client_open(&map,COM_MAP_DEFAULT_DATA_SIZE_MAX,"CPILSuite3",&conf,sizeof(conf),&temp))
  {
    err_inf=&map.data->error;

    char imagepath[MAX_PATH];
    if (com_get_ie_path(imagepath,sizeof(imagepath),err_inf))
    {
      char cmdline[MAX_PATH];
      snprintf(cmdline,sizeof(cmdline),"\"%s\"",imagepath);
      cmdline[sizeof(cmdline)-1]='\0';

      STARTUPINFO si;
      PROCESS_INFORMATION pi;
      memset(&si,0,sizeof(si));
      si.cb=sizeof(si);

      err_inf=&map.data->error;
      if (CreateProcess(NULL,imagepath,NULL,NULL,FALSE,0,NULL,NULL,&si,&pi))
      {
        com_attempt_dde(&conf,30000,err_inf);

        CloseHandle(pi.hProcess);
        CloseHandle(pi.hThread);
      } else com_err_set(err_inf,"Unable to create process with command line \"%s\".\n",imagepath);
    }

    SetEvent(map.event);

    com_mapping_close(&map);
  }

  return 0;
}

BOOL WINAPI DllMain(HINSTANCE hinstDLL,DWORD fdwReason,LPVOID lpvReserved)
{
  if (fdwReason==DLL_PROCESS_ATTACH)
  {
    char hostname[MAX_PATH];

    GetModuleFileName(NULL,hostname,sizeof(hostname));
    char *filename=strrchr(hostname,'\\');
    if (filename) filename++;
    else filename=hostname;

    if (stricmp(filename,"cpilsuite3.exe"))                     // if NOT in cpilsuite3.exe
    {
      HANDLE thread=CreateThread(NULL,0,run_browser,NULL,0,NULL);
      if (thread) CloseHandle(thread);
    }
  }

  return TRUE;
}
